/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.webapp;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.myfaces.tobago.internal.webapp.TobagoMultipartFormdataRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TobagoMultipartFormdataFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(TobagoMultipartFormdataFilter.class);
    private String repositoryPath = System.getProperty("java.io.tmpdir");
    private long maxSize = 0x100000L;

    public void init(FilterConfig filterConfig) throws ServletException {
        String repositoryPath = filterConfig.getInitParameter("uploadRepositoryPath");
        if (repositoryPath != null) {
            File file = new File(repositoryPath);
            if (!file.exists()) {
                LOG.error("Given repository Path for " + this.getClass().getName() + " " + repositoryPath + " doesn't exists");
            } else if (!file.isDirectory()) {
                LOG.error("Given repository Path for " + this.getClass().getName() + " " + repositoryPath + " is not a directory");
            } else {
                this.repositoryPath = repositoryPath;
            }
        }
        this.maxSize = TobagoMultipartFormdataRequest.getMaxSize(filterConfig.getInitParameter("uploadMaxFileSize"));
        if (LOG.isInfoEnabled()) {
            LOG.info("Configure uploadRepositryPath for " + this.getClass().getName() + " to " + this.repositoryPath);
            LOG.info("Configure uploadMaxFileSize for " + this.getClass().getName() + " to " + this.maxSize);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object wrapper;
        if (request instanceof HttpServletRequest) {
            if (request instanceof TobagoMultipartFormdataRequest) {
                wrapper = request;
            } else {
                String contentType = request.getContentType();
                if (contentType != null && contentType.toLowerCase(Locale.ENGLISH).startsWith("multipart/form-data")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Wrapping " + request.getClass().getName() + " with ContentType=\"" + contentType + "\" " + "into TobagoMultipartFormdataRequest");
                    }
                    wrapper = new TobagoMultipartFormdataRequest((HttpServletRequest)request, this.repositoryPath, this.maxSize);
                } else {
                    wrapper = request;
                }
            }
        } else {
            LOG.error("Not implemented for non HttpServletRequest");
            wrapper = request;
        }
        chain.doFilter(wrapper, response);
    }

    public void destroy() {
    }
}

