/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.util;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.apache.myfaces.tobago.internal.layout.LayoutContext;
import org.apache.myfaces.tobago.layout.LayoutContainer;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.util.TobagoCallback;

public class EncodeAjaxCallback
implements TobagoCallback {
    public void invokeContextCallback(FacesContext facesContext, UIComponent component) {
        try {
            Boolean update;
            Boolean immediate;
            UIComponent reload = component.getFacet("reload");
            if (reload != null && reload.isRendered() && (immediate = (Boolean)reload.getAttributes().get("immediate")) != null && !immediate.booleanValue() && (update = (Boolean)reload.getAttributes().get("update")) != null && !update.booleanValue()) {
                return;
            }
            EncodeAjaxCallback.prepareRendererAll(facesContext, component);
            if (component instanceof LayoutContainer) {
                LayoutContainer layoutContainer = (LayoutContainer)component;
                Measure width = layoutContainer.getCurrentWidth();
                Measure height = layoutContainer.getCurrentHeight();
                Measure oldWidth = layoutContainer.getWidth();
                Measure oldHeight = layoutContainer.getHeight();
                layoutContainer.setWidth(width);
                layoutContainer.setHeight(height);
                new LayoutContext(layoutContainer).layout();
                layoutContainer.setWidth(oldWidth);
                layoutContainer.setHeight(oldHeight);
            }
            EncodeAjaxCallback.encodeAll(facesContext, component);
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    public static void encodeAll(FacesContext facesContext, UIComponent component) throws IOException {
        if (component.isRendered()) {
            component.encodeBegin(facesContext);
            if (component.getRendersChildren()) {
                component.encodeChildren(facesContext);
            } else {
                for (Object o : component.getChildren()) {
                    UIComponent kid = (UIComponent)o;
                    EncodeAjaxCallback.encodeAll(facesContext, kid);
                }
            }
            component.encodeEnd(facesContext);
        }
    }

    public static void prepareRendererAll(FacesContext facesContext, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        RendererBase renderer = ComponentUtils.getRenderer(facesContext, component);
        boolean prepareRendersChildren = false;
        if (renderer != null) {
            renderer.prepareRender(facesContext, component);
            prepareRendersChildren = renderer.getPrepareRendersChildren();
        }
        if (prepareRendersChildren) {
            renderer.prepareRendersChildren(facesContext, component);
        } else {
            Iterator it = component.getFacetsAndChildren();
            while (it.hasNext()) {
                UIComponent child = (UIComponent)it.next();
                EncodeAjaxCallback.prepareRendererAll(facesContext, child);
            }
        }
    }
}

