/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.model;

import java.util.ArrayList;
import java.util.List;
import javax.faces.event.ActionEvent;
import org.apache.myfaces.tobago.model.WizardStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wizard {
    private static final Logger LOG = LoggerFactory.getLogger(Wizard.class);
    private int index;
    private List<WizardStep> course;

    public Wizard() {
        this.reset();
    }

    public void next(ActionEvent event) {
        LOG.debug("next: " + event);
        ++this.index;
    }

    public void gotoStep(ActionEvent event) {
        Object step = event.getComponent().getAttributes().get("step");
        this.index = step instanceof Integer ? (Integer)step : Integer.parseInt((String)step);
        LOG.debug("gotoStep: " + this.index);
    }

    public String previous() {
        String outcome = this.getPreviousStep().getOutcome();
        if (this.index > 0) {
            --this.index;
        } else {
            LOG.error("Previous not available!");
        }
        LOG.debug("gotoStep: " + this.index);
        return outcome;
    }

    public final boolean isPreviousAvailable() {
        return this.getIndex() > 0;
    }

    public final void finish(ActionEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("finish");
        }
        this.reset();
    }

    public final void cancel(ActionEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("cancel");
        }
        this.reset();
    }

    public final int getIndex() {
        return this.index;
    }

    public void reset() {
        this.index = 0;
        this.course = new ArrayList<WizardStep>();
    }

    public List<WizardStep> getCourse() {
        return this.course;
    }

    public int getSize() {
        return this.course.size();
    }

    public void register() {
        if (this.index == this.course.size()) {
            this.course.add(new WizardStep(this.index));
        } else if (this.index < this.course.size()) {
            this.course.set(this.index, new WizardStep(this.index));
        } else {
            throw new IllegalStateException("Index too large for course: index=" + this.index + " course.size()=" + this.course.size());
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("course: " + this.course);
        }
    }

    public WizardStep getPreviousStep() {
        if (this.index > 0) {
            return this.course.get(this.index - 1);
        }
        return null;
    }

    public WizardStep getCurrentStep() {
        return this.course.get(this.index);
    }

    public void removeForwardSteps() {
        LOG.error("Not implemented yet");
    }
}

