/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.layout;

import org.apache.myfaces.tobago.layout.Measure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PixelMeasure
extends Measure {
    private static final Logger LOG = LoggerFactory.getLogger(PixelMeasure.class);
    static final Measure[] PIXEL_CACHE = new Measure[4001];
    static final int PIXEL_CACHE_MAX = 4000;
    private final int pixel;

    private PixelMeasure(int pixel) {
        this.pixel = pixel;
    }

    static Measure pixelValueOf(int value) {
        if (value >= 0 && value <= 4000) {
            return PIXEL_CACHE[value];
        }
        return new PixelMeasure(value);
    }

    public Measure add(Measure m) {
        if (m == null) {
            return this;
        }
        return PixelMeasure.pixelValueOf(this.pixel + m.getPixel());
    }

    public Measure add(int m) {
        return PixelMeasure.pixelValueOf(this.pixel + m);
    }

    public Measure multiply(int times) {
        return PixelMeasure.pixelValueOf(this.pixel * times);
    }

    public Measure divide(int times) {
        return PixelMeasure.pixelValueOf(this.pixel / times);
    }

    public Measure subtractNotNegative(Measure m) {
        if (m == null) {
            return this;
        }
        if (m.getPixel() > this.pixel) {
            LOG.warn("Not enough space! value=" + this.pixel);
            return ZERO;
        }
        return PixelMeasure.pixelValueOf(this.pixel - m.getPixel());
    }

    public Measure subtract(Measure m) {
        if (m == null) {
            return this;
        }
        return PixelMeasure.pixelValueOf(this.pixel - m.getPixel());
    }

    public Measure subtract(int m) {
        return PixelMeasure.pixelValueOf(this.pixel - m);
    }

    public int getPixel() {
        return this.pixel;
    }

    public String toString() {
        return this.pixel + "px";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PixelMeasure that = (PixelMeasure)o;
        return this.pixel == that.pixel;
    }

    public int hashCode() {
        return this.pixel;
    }

    static {
        for (int i = 0; i < PIXEL_CACHE.length; ++i) {
            PixelMeasure.PIXEL_CACHE[i] = new PixelMeasure(i);
        }
    }
}

