/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.layout;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.myfaces.tobago.layout.AutoLayoutToken;
import org.apache.myfaces.tobago.layout.LayoutToken;
import org.apache.myfaces.tobago.layout.MinimumLayoutToken;
import org.apache.myfaces.tobago.layout.PercentLayoutToken;
import org.apache.myfaces.tobago.layout.PixelLayoutToken;
import org.apache.myfaces.tobago.layout.RelativeLayoutToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LayoutTokens
implements Iterable<LayoutToken> {
    private static final Logger LOG = LoggerFactory.getLogger(LayoutTokens.class);
    private List<LayoutToken> tokens = new ArrayList<LayoutToken>();

    public int getSize() {
        return this.tokens.size();
    }

    public void set(int index, LayoutToken token) {
        this.tokens.set(index, token);
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public LayoutToken get(int index) {
        return this.tokens.get(index);
    }

    public void shrinkSizeTo(int size) {
        for (int i = this.getSize() - 1; i >= size; --i) {
            this.tokens.remove(i);
        }
    }

    public void ensureSize(int size, LayoutToken token) {
        for (int index = this.getSize(); index < size; ++index) {
            this.addToken(token);
        }
    }

    public void addToken(LayoutToken token) {
        this.tokens.add(token);
    }

    public List<LayoutToken> getTokens() {
        return this.tokens;
    }

    @Override
    public Iterator<LayoutToken> iterator() {
        return this.tokens.iterator();
    }

    public static LayoutTokens parse(String[] tokens) {
        LayoutTokens layoutTokens = new LayoutTokens();
        for (String token : tokens) {
            LayoutTokens.parseToken(token, layoutTokens);
        }
        return layoutTokens;
    }

    public static LayoutTokens parse(String tokens) {
        return LayoutTokens.parse(tokens, null);
    }

    public static LayoutTokens parse(String tokens, LayoutToken defaultToken) {
        LayoutTokens layoutTokens = new LayoutTokens();
        if (tokens == null) {
            layoutTokens.addToken(defaultToken);
            return layoutTokens;
        }
        StringTokenizer tokenizer = new StringTokenizer(tokens, ";");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            LayoutTokens.parseToken(token, layoutTokens);
        }
        return layoutTokens;
    }

    private static void parseToken(String token, LayoutTokens layoutTokens) {
        LayoutToken layoutToken = LayoutTokens.parseToken(token);
        if (layoutToken != null) {
            layoutTokens.addToken(layoutToken);
        }
    }

    public static LayoutToken parseToken(String token) {
        try {
            if ("*".equals(token)) {
                return RelativeLayoutToken.DEFAULT_INSTANCE;
            }
            if (token == null) {
                LOG.error("Empty layout token! Using 'auto' instead.");
                return AutoLayoutToken.INSTANCE;
            }
            if ("fixed".equals(token) || "auto".equals(token)) {
                return AutoLayoutToken.INSTANCE;
            }
            if ("minimum".equals(token)) {
                return new MinimumLayoutToken();
            }
            if (LayoutTokens.isPixelToken(token)) {
                return new PixelLayoutToken(Integer.parseInt(LayoutTokens.removeSuffix(token, "px")));
            }
            if (LayoutTokens.isPercentToken(token)) {
                return new PercentLayoutToken(Integer.parseInt(LayoutTokens.removeSuffix(token, "%")));
            }
            if (LayoutTokens.isRelativeToken(token)) {
                return new RelativeLayoutToken(Integer.parseInt(LayoutTokens.removeSuffix(token, "*")));
            }
            LOG.error("Unknown layout token '" + token + "'! Using 'auto' instead.");
            return AutoLayoutToken.INSTANCE;
        }
        catch (NumberFormatException e) {
            LOG.error("Error parsing layout token '" + token + "'! Using 'auto' instead.");
            return AutoLayoutToken.INSTANCE;
        }
    }

    static boolean isPixelToken(String token) {
        return LayoutTokens.isNumberAndSuffix(token, "px");
    }

    static boolean isPercentToken(String token) {
        return LayoutTokens.isNumberAndSuffix(token, "%");
    }

    static boolean isRelativeToken(String token) {
        return LayoutTokens.isNumberAndSuffix(token, "*");
    }

    static boolean isNumberAndSuffix(String token, String suffix) {
        return token.endsWith(suffix) && NumberUtils.isDigits((String)LayoutTokens.removeSuffix(token, suffix));
    }

    private static String removeSuffix(String token, String suffix) {
        return token.substring(0, token.length() - suffix.length());
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (LayoutToken token : this.tokens) {
            str.append(token);
            str.append(";");
        }
        return str.toString();
    }
}

