/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.webapp;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.tobago.internal.webapp.TobagoResponseWriterBase;
import org.apache.myfaces.tobago.util.XmlUtils;

public final class XmlResponseWriter
extends TobagoResponseWriterBase {
    private static final String XHTML_DOCTYPE = "<!DOCTYPE html      PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"     \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">";

    public XmlResponseWriter(Writer writer, String contentType, String characterEncoding) {
        super(writer, contentType, characterEncoding);
    }

    public void writeText(Object text, String property) throws IOException {
        this.closeOpenTag();
        String value = this.findValue(text, property);
        this.write(XmlUtils.escape(value));
    }

    public void writeText(char[] text, int offset, int length) throws IOException {
        this.closeOpenTag();
        this.getWriter().write(XmlUtils.escape(text, offset, length, true));
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (!Arrays.equals(cbuf, XML_VERSION_1_0_ENCODING_UTF_8_CHARS)) {
            super.write(cbuf, off, len);
        }
    }

    public ResponseWriter cloneWithWriter(Writer originalWriter) {
        return new XmlResponseWriter(originalWriter, this.getContentType(), this.getCharacterEncoding());
    }

    public void closeEmptyTag() throws IOException {
        this.getWriter().write("\n/>");
    }

    protected void writerAttributeValue(String value, boolean escape) throws IOException {
        this.getWriter().write(XmlUtils.escape(value));
    }

    public void startDocument() throws IOException {
        this.getWriter().write(XHTML_DOCTYPE);
        this.getWriter().write(10);
        this.startElement("html", null);
        this.writeAttribute("xmlns", "http://www.w3.org/1999/xhtml", false);
    }

    public void endDocument() throws IOException {
        this.endElement("html");
    }
}

