/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtils {
    private StringUtils() {
    }

    public static List<Integer> parseIntegerList(String integerList) throws NumberFormatException {
        return StringUtils.parseIntegerList(integerList, ", ");
    }

    public static List<Integer> parseIntegerList(String integerList, String delimiters) throws NumberFormatException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        StringTokenizer tokenizer = new StringTokenizer(integerList, delimiters);
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken().trim();
            if (token.length() <= 0) continue;
            list.add(new Integer(token));
        }
        return list;
    }

    public static <T> String joinWithSurroundingSeparator(List<T> list) {
        StringBuilder buffer = new StringBuilder(",");
        for (T t : list) {
            buffer.append(t);
            buffer.append(",");
        }
        return buffer.toString();
    }

    public static int[] getIndices(String list) {
        ArrayList<String> indexList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(list, ",");
        while (st.hasMoreTokens()) {
            int i;
            int end;
            String token = st.nextToken().trim();
            int idx = token.indexOf(45);
            if (idx == -1) {
                indexList.add(token);
                continue;
            }
            int start = Integer.parseInt(token.substring(0, idx).trim());
            if (start < (end = Integer.parseInt(token.substring(idx + 1).trim()))) {
                for (i = start; i < end + 1; ++i) {
                    indexList.add(Integer.toString(i));
                }
                continue;
            }
            for (i = start; i > end - 1; --i) {
                indexList.add(Integer.toString(i));
            }
        }
        int[] indices = new int[indexList.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = Integer.parseInt((String)indexList.get(i));
        }
        return indices;
    }

    public static String constantToCamelCase(String constant) {
        StringBuilder builder = new StringBuilder(constant.length());
        char[] chars = constant.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (i == 0) {
                builder.append(chars[i]);
                continue;
            }
            if (chars[i] == '_') {
                builder.append(chars[++i]);
                continue;
            }
            builder.append(Character.valueOf(chars[i]).toString().toLowerCase(Locale.ENGLISH));
        }
        return builder.toString();
    }

    public static boolean equalsIgnoreCaseAndWhitespace(String type1, String type2) {
        if (type1 == type2) {
            return true;
        }
        if (type1 == null || type2 == null) {
            return false;
        }
        char[] chars1 = type1.toCharArray();
        char[] chars2 = type2.toCharArray();
        int length1 = chars1.length;
        int length = chars2.length;
        int i = 0;
        int j = 0;
        while (i < length1 && j < length) {
            if (chars1[i] == chars2[j] || Character.toUpperCase(chars1[i]) == Character.toUpperCase(chars2[j])) {
                ++i;
                ++j;
                continue;
            }
            if (Character.isWhitespace(chars1[i])) {
                ++i;
                continue;
            }
            if (Character.isWhitespace(chars2[j])) {
                ++j;
                continue;
            }
            return false;
        }
        while (i < length1) {
            if (Character.isWhitespace(chars1[i])) {
                ++i;
                continue;
            }
            return false;
        }
        while (j < length) {
            if (Character.isWhitespace(chars2[j])) {
                ++j;
                continue;
            }
            return false;
        }
        return true;
    }

    public static boolean isUrl(String link) {
        if (link == null) {
            return false;
        }
        int colon = link.indexOf(58);
        if (colon < 1) {
            return false;
        }
        for (int i = 0; i < colon; ++i) {
            if (Character.isLetter(link.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

