/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import java.io.IOException;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseWriterBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseWriterBuffer.class);
    private static final int BUFFER_SIZE = 64;
    private final char[] buff = new char[64];
    private int bufferIndex;
    private final Writer writer;

    public ResponseWriterBuffer(Writer writer) {
        this.writer = writer;
    }

    public void addToBuffer(char ch) throws IOException {
        if (this.bufferIndex >= 64) {
            this.writer.write(this.buff, 0, this.bufferIndex);
            this.bufferIndex = 0;
        }
        this.buff[this.bufferIndex++] = ch;
    }

    public void addToBuffer(char[] ch) throws IOException {
        if (this.bufferIndex + ch.length >= 64) {
            this.writer.write(this.buff, 0, this.bufferIndex);
            this.bufferIndex = 0;
        }
        System.arraycopy(ch, 0, this.buff, this.bufferIndex, ch.length);
        this.bufferIndex += ch.length;
    }

    public void flushBuffer() throws IOException {
        if (this.bufferIndex > 0) {
            this.writer.write(this.buff, 0, this.bufferIndex);
        }
        this.bufferIndex = 0;
    }
}

