/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseUtils.class);

    private ResponseUtils() {
    }

    public static void ensureNoCacheHeader(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        if (externalContext.getResponse() instanceof HttpServletResponse) {
            HttpServletResponse response = (HttpServletResponse)externalContext.getResponse();
            ResponseUtils.ensureNoCacheHeader(response);
        }
    }

    public static void ensureNoCacheHeader(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache,no-store,max-age=0,must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setDateHeader("max-age", 0L);
    }

    public static void ensureContentTypeHeader(FacesContext facesContext, String contentType) {
        if (facesContext.getExternalContext().getResponse() instanceof HttpServletResponse) {
            HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
            ResponseUtils.ensureContentTypeHeader(response, contentType);
        }
    }

    public static void ensureContentTypeHeader(HttpServletResponse response, String contentType) {
        if (!response.containsHeader("Content-Type")) {
            response.setContentType(contentType);
        } else {
            String responseContentType = response.getContentType();
            if (!StringUtils.equalsIgnoreCaseAndWhitespace(responseContentType, contentType)) {
                response.setContentType(contentType);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Response already contains Header Content-Type '" + responseContentType + "'. Overwriting with '" + contentType + "'");
                }
            }
        }
    }
}

