/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.apache.commons.collections.list.SetUniqueList;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.myfaces.tobago.compat.FacesUtils;
import org.apache.myfaces.tobago.internal.component.AbstractUIPopup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FacesContextUtils {
    private static final String TOBAGO_AJAX = "org.apache.myfaces.tobago.ajax";
    private static final String TOBAGO_AJAX_COMPONENT_ID = "org.apache.myfaces.tobago.ajaxComponentId";
    private static final String TOBAGO_ENCTYPE = "org.apache.myfaces.tobago.enctype";
    private static final String TOBAGO_SCRIPT_FILES = "org.apache.myfaces.tobago.scriptFiles";
    private static final String TOBAGO_SCRIPT_BLOCKS = "org.apache.myfaces.tobago.scriptBlocks";
    private static final String TOBAGO_STYLE_FILES = "org.apache.myfaces.tobago.styleFiles";
    private static final String TOBAGO_STYLE_BLOCKS = "org.apache.myfaces.tobago.styleBlocks";
    private static final String TOBAGO_ONLOAD_SCRIPTS = "org.apache.myfaces.tobago.onloadScripts";
    private static final String TOBAGO_ONUNLOAD_SCRIPTS = "org.apache.myfaces.tobago.onunloadScripts";
    private static final String TOBAGO_ONEXIT_SCRIPTS = "org.apache.myfaces.tobago.onexitScripts";
    private static final String TOBAGO_ONSUBMIT_SCRIPTS = "org.apache.myfaces.tobago.onsubmitScripts";
    private static final String TOBAGO_POPUPS = "org.apache.myfaces.tobago.popups";
    private static final String TOBAGO_MENU_ACCELERATORS = "org.apache.myfaces.tobago.menuAccelerators";

    public static boolean isAjax(FacesContext context) {
        return FacesUtils.getFacesContextAttributes((FacesContext)context).containsKey(TOBAGO_AJAX);
    }

    public static void setAjax(FacesContext context, boolean ajax) {
        FacesUtils.getFacesContextAttributes((FacesContext)context).put(TOBAGO_AJAX, ajax);
    }

    public static String getAjaxComponentId(FacesContext context) {
        return (String)FacesUtils.getFacesContextAttributes((FacesContext)context).get(TOBAGO_AJAX_COMPONENT_ID);
    }

    public static void setAjaxComponentId(FacesContext context, String ajaxComponentId) {
        FacesUtils.getFacesContextAttributes((FacesContext)context).put(TOBAGO_AJAX_COMPONENT_ID, ajaxComponentId);
    }

    public static String getEnctype(FacesContext context) {
        return (String)FacesUtils.getFacesContextAttributes((FacesContext)context).get(TOBAGO_ENCTYPE);
    }

    public static void setEnctype(FacesContext context, String enctype) {
        FacesUtils.getFacesContextAttributes((FacesContext)context).put(TOBAGO_ENCTYPE, enctype);
    }

    public static List<String> getScriptFiles(FacesContext context) {
        List list = (List)FacesUtils.getFacesContextAttributes((FacesContext)context).get(TOBAGO_SCRIPT_FILES);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    public static void addScriptFile(FacesContext context, String file) {
        List list = (List)FacesUtils.getFacesContextAttributes((FacesContext)context).get(TOBAGO_SCRIPT_FILES);
        if (list == null) {
            list = SetUniqueList.decorate(new ArrayList());
            FacesUtils.getFacesContextAttributes((FacesContext)context).put(TOBAGO_SCRIPT_FILES, list);
        }
        list.add(file);
    }

    public static Set<String> getScriptBlocks(FacesContext context) {
        Set set = (Set)FacesUtils.getFacesContextAttributes((FacesContext)context).get(TOBAGO_SCRIPT_BLOCKS);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public static void addScriptBlock(FacesContext context, String script) {
        Set set = (Set)FacesUtils.getFacesContextAttributes((FacesContext)context).get(TOBAGO_SCRIPT_BLOCKS);
        if (set == null) {
            set = new ListOrderedSet();
            FacesUtils.getFacesContextAttributes((FacesContext)context).put(TOBAGO_SCRIPT_BLOCKS, set);
        }
        set.add(script);
    }

    public static Set<String> getStyleFiles(FacesContext context) {
        Set set = (Set)FacesUtils.getFacesContextAttributes((FacesContext)context).get(TOBAGO_STYLE_FILES);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public static void addStyleFile(FacesContext context, String script) {
        Set set = (Set)FacesUtils.getFacesContextAttributes((FacesContext)context).get(TOBAGO_STYLE_FILES);
        if (set == null) {
            set = new ListOrderedSet();
            FacesUtils.getFacesContextAttributes((FacesContext)context).put(TOBAGO_STYLE_FILES, set);
        }
        set.add(script);
    }

    public static Set<String> getStyleBlocks(FacesContext context) {
        Set set = (Set)FacesUtils.getFacesContextAttributes((FacesContext)context).get(TOBAGO_STYLE_BLOCKS);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public static void addStyleBlock(FacesContext context, String script) {
        Set set = (Set)FacesUtils.getFacesContextAttributes((FacesContext)context).get(TOBAGO_STYLE_BLOCKS);
        if (set == null) {
            set = new ListOrderedSet();
            FacesUtils.getFacesContextAttributes((FacesContext)context).put(TOBAGO_STYLE_BLOCKS, set);
        }
        set.add(script);
    }

    public static List<String> getOnloadScripts(FacesContext context) {
        List list = (List)FacesUtils.getFacesContextAttributes((FacesContext)context).get(TOBAGO_ONLOAD_SCRIPTS);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    public static void addOnloadScript(FacesContext context, String file) {
        List list = (List)FacesUtils.getFacesContextAttributes((FacesContext)context).get(TOBAGO_ONLOAD_SCRIPTS);
        if (list == null) {
            list = SetUniqueList.decorate(new ArrayList());
            FacesUtils.getFacesContextAttributes((FacesContext)context).put(TOBAGO_ONLOAD_SCRIPTS, list);
        }
        list.add(file);
    }

    public static void addOnloadScript(FacesContext context, int position, String file) {
        List list = (List)FacesUtils.getFacesContextAttributes((FacesContext)context).get(TOBAGO_ONLOAD_SCRIPTS);
        if (list == null) {
            list = SetUniqueList.decorate(new ArrayList());
            FacesUtils.getFacesContextAttributes((FacesContext)context).put(TOBAGO_ONLOAD_SCRIPTS, list);
        }
        list.add(position, file);
    }

    public static Set<String> getOnunloadScripts(FacesContext context) {
        Set set = (Set)FacesUtils.getFacesContextAttributes((FacesContext)context).get(TOBAGO_ONUNLOAD_SCRIPTS);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public static void addOnunloadScript(FacesContext context, String script) {
        Set set = (Set)FacesUtils.getFacesContextAttributes((FacesContext)context).get(TOBAGO_ONUNLOAD_SCRIPTS);
        if (set == null) {
            set = new ListOrderedSet();
            FacesUtils.getFacesContextAttributes((FacesContext)context).put(TOBAGO_ONUNLOAD_SCRIPTS, set);
        }
        set.add(script);
    }

    public static Set<String> getOnexitScripts(FacesContext context) {
        Set set = (Set)FacesUtils.getFacesContextAttributes((FacesContext)context).get(TOBAGO_ONEXIT_SCRIPTS);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public static void addOnexitScript(FacesContext context, String script) {
        Set set = (Set)FacesUtils.getFacesContextAttributes((FacesContext)context).get(TOBAGO_ONEXIT_SCRIPTS);
        if (set == null) {
            set = new ListOrderedSet();
            FacesUtils.getFacesContextAttributes((FacesContext)context).put(TOBAGO_ONEXIT_SCRIPTS, set);
        }
        set.add(script);
    }

    public static Set<String> getOnsubmitScripts(FacesContext context) {
        Set set = (Set)FacesUtils.getFacesContextAttributes((FacesContext)context).get(TOBAGO_ONSUBMIT_SCRIPTS);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public static void addOnsubmitScript(FacesContext context, String script) {
        Set set = (Set)FacesUtils.getFacesContextAttributes((FacesContext)context).get(TOBAGO_ONSUBMIT_SCRIPTS);
        if (set == null) {
            set = new ListOrderedSet();
            FacesUtils.getFacesContextAttributes((FacesContext)context).put(TOBAGO_ONSUBMIT_SCRIPTS, set);
        }
        set.add(script);
    }

    public static void clearMenuAcceleratorScripts(FacesContext context) {
        Set set = (Set)FacesUtils.getFacesContextAttributes((FacesContext)context).get(TOBAGO_MENU_ACCELERATORS);
        set.clear();
    }

    public static Set<String> getMenuAcceleratorScripts(FacesContext context) {
        Set set = (Set)FacesUtils.getFacesContextAttributes((FacesContext)context).get(TOBAGO_MENU_ACCELERATORS);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public static void addMenuAcceleratorScript(FacesContext context, String script) {
        Set set = (Set)FacesUtils.getFacesContextAttributes((FacesContext)context).get(TOBAGO_MENU_ACCELERATORS);
        if (set == null) {
            set = new ListOrderedSet();
            FacesUtils.getFacesContextAttributes((FacesContext)context).put(TOBAGO_MENU_ACCELERATORS, set);
        }
        set.add(script);
    }

    public static Set<AbstractUIPopup> getPopups(FacesContext context) {
        Set set = (Set)FacesUtils.getFacesContextAttributes((FacesContext)context).get(TOBAGO_POPUPS);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public static void addPopup(FacesContext context, AbstractUIPopup popup) {
        Set set = (Set)FacesUtils.getFacesContextAttributes((FacesContext)context).get(TOBAGO_POPUPS);
        if (set == null) {
            set = new ListOrderedSet();
            FacesUtils.getFacesContextAttributes((FacesContext)context).put(TOBAGO_POPUPS, set);
        }
        set.add(popup);
    }
}

