/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib.component;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.myfaces.tobago.compat.FacesUtils;
import org.apache.myfaces.tobago.event.TabChangeListener;
import org.apache.myfaces.tobago.event.TabChangeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TabChangeListenerTag
extends TagSupport {
    private static final long serialVersionUID = -419199086962377873L;
    private static final Logger LOG = LoggerFactory.getLogger(TabChangeListenerTag.class);

    public abstract String getTypeValue();

    public abstract boolean isTypeSet();

    public abstract boolean isTypeLiteral();

    public abstract String getBindingValue();

    public abstract boolean isBindingSet();

    public abstract boolean isBindingLiteral();

    public abstract Object getBindingAsBindingOrExpression();

    public int doStartTag() throws JspException {
        Object obj;
        UIComponentTag tag = UIComponentTag.getParentUIComponentTag((PageContext)this.pageContext);
        if (tag == null) {
            throw new JspException("Not nested in faces tag");
        }
        if (!tag.getCreated()) {
            return 0;
        }
        UIComponent component = tag.getComponentInstance();
        if (component == null) {
            throw new JspException("Component Instance is null");
        }
        if (!(component instanceof TabChangeSource)) {
            throw new JspException("Component " + component.getClass().getName() + " is not instanceof TabChangeSource");
        }
        TabChangeSource changeSource = (TabChangeSource)component;
        TabChangeListener handler = null;
        Object valueBinding = null;
        if (this.isBindingSet() && !this.isBindingLiteral() && (valueBinding = this.getBindingAsBindingOrExpression()) != null && (obj = FacesUtils.getValueFromBindingOrExpression((Object)valueBinding)) != null && obj instanceof TabChangeListener) {
            handler = (TabChangeListener)obj;
        }
        if (handler == null && this.isTypeSet() && (handler = this.createTabChangeListener(this.getTypeValue())) != null && valueBinding != null) {
            FacesUtils.setValueOfBindingOrExpression((FacesContext)FacesContext.getCurrentInstance(), (Object)handler, (Object)valueBinding);
        }
        if (handler != null) {
            if (valueBinding != null) {
                FacesUtils.addBindingOrExpressionTabChangeListener((TabChangeSource)changeSource, (String)this.getTypeValue(), (Object)valueBinding);
            } else {
                changeSource.addTabChangeListener(handler);
            }
        }
        return 0;
    }

    protected TabChangeListener createTabChangeListener(String className) throws JspException {
        try {
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(className);
            return (TabChangeListener)clazz.newInstance();
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
    }
}

