/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib.component;

import javax.faces.component.UIComponent;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.myfaces.tobago.compat.FacesUtils;
import org.apache.myfaces.tobago.component.SupportsRenderedPartially;
import org.apache.myfaces.tobago.util.ComponentUtils;

public abstract class AttributeTag
extends TagSupport {
    public abstract boolean isNameLiteral();

    public abstract Object getNameAsBindingOrExpression();

    public abstract String getNameValue();

    public abstract String getNameExpression();

    public abstract boolean isValueLiteral();

    public abstract Object getValueAsBindingOrExpression();

    public abstract String getValueValue();

    public abstract String getValueExpression();

    public void setMode(String mode) {
        throw new RuntimeException("The mode is only available when using Facelets, not with JSP.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doStartTag() throws JspException {
        String attributeName;
        UIComponentTag tag = UIComponentTag.getParentUIComponentTag((PageContext)this.pageContext);
        if (tag == null) {
            throw new JspException("Not nested in faces tag");
        }
        if (!tag.getCreated()) {
            return 0;
        }
        UIComponent component = tag.getComponentInstance();
        if (component == null) {
            throw new JspException("Component Instance is null");
        }
        if (!this.isNameLiteral()) {
            Object nameValueBindingOrValueExpression = this.getNameAsBindingOrExpression();
            if (nameValueBindingOrValueExpression == null) throw new JspException("Can not get ValueBinding for attribute name " + this.getNameExpression());
            attributeName = (String)FacesUtils.getValueFromBindingOrExpression((Object)nameValueBindingOrValueExpression);
        } else {
            attributeName = this.getNameValue();
        }
        if (!this.isValueLiteral()) {
            Object obj = this.getValueAsBindingOrExpression();
            if (obj == null) throw new JspException("Can not get ValueBinding for attribute value " + this.getValueExpression());
            FacesUtils.setBindingOrExpression((UIComponent)component, (String)attributeName, (Object)obj);
            return 0;
        } else if ("styleClass".equals(attributeName)) {
            ComponentUtils.setStyleClasses(component, this.getValueValue());
            return 0;
        } else if ("renderedPartially".equals(attributeName) && component instanceof SupportsRenderedPartially) {
            String[] components = ComponentUtils.splitList(this.getValueValue());
            ((SupportsRenderedPartially)component).setRenderedPartially(components);
            return 0;
        } else {
            component.getAttributes().put(attributeName, this.getValueValue());
        }
        return 0;
    }
}

