/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib;

import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITreeSelect;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.taglib.TobagoELTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TreeSelectTag
extends TobagoELTag {
    private static final Logger LOG = LoggerFactory.getLogger(TreeSelectTag.class);
    private ValueExpression markup;
    private ValueExpression value;
    private ValueExpression label;
    private ValueExpression showCheckbox;
    private ValueExpression tip;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.TreeSelect";
    }

    public String getRendererType() {
        return "TreeSelect";
    }

    protected void setProperties(UIComponent uiComponent) {
        super.setProperties(uiComponent);
        UITreeSelect component = (UITreeSelect)uiComponent;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (this.markup != null) {
            if (!this.markup.isLiteralText()) {
                component.setValueExpression("markup", this.markup);
            } else {
                component.setMarkup(Markup.valueOf(this.markup.getExpressionString()));
            }
        }
        if (this.value != null) {
            component.setValueExpression("value", this.value);
        }
        if (this.label != null) {
            component.setValueExpression("label", this.label);
        }
        if (this.showCheckbox != null) {
            if (!this.showCheckbox.isLiteralText()) {
                component.setValueExpression("showCheckbox", this.showCheckbox);
            } else {
                component.setShowCheckbox(Boolean.parseBoolean(this.showCheckbox.getExpressionString()));
            }
        }
        if (this.tip != null) {
            component.setValueExpression("tip", this.tip);
        }
    }

    public ValueExpression getMarkup() {
        return this.markup;
    }

    public void setMarkup(ValueExpression markup) {
        this.markup = markup;
    }

    public ValueExpression getValue() {
        return this.value;
    }

    public void setValue(ValueExpression value) {
        this.value = value;
    }

    public ValueExpression getLabel() {
        return this.label;
    }

    public void setLabel(ValueExpression label) {
        this.label = label;
    }

    public ValueExpression getShowCheckbox() {
        return this.showCheckbox;
    }

    public void setShowCheckbox(ValueExpression showCheckbox) {
        this.showCheckbox = showCheckbox;
    }

    public ValueExpression getTip() {
        return this.tip;
    }

    public void setTip(ValueExpression tip) {
        this.tip = tip;
    }

    public void release() {
        super.release();
        this.markup = null;
        this.value = null;
        this.label = null;
        this.showCheckbox = null;
        this.tip = null;
    }
}

