/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib;

import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.taglib.TobagoELTag;
import org.apache.myfaces.tobago.layout.Measure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PageTag
extends TobagoELTag {
    private static final Logger LOG = LoggerFactory.getLogger(PageTag.class);
    private ValueExpression markup;
    private ValueExpression state;
    private ValueExpression focusId;
    private ValueExpression height;
    private ValueExpression width;
    private ValueExpression label;
    private ValueExpression applicationIcon;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.Page";
    }

    public String getRendererType() {
        return "Page";
    }

    protected void setProperties(UIComponent uiComponent) {
        super.setProperties(uiComponent);
        UIPage component = (UIPage)uiComponent;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (this.markup != null) {
            if (!this.markup.isLiteralText()) {
                component.setValueExpression("markup", this.markup);
            } else {
                component.setMarkup(Markup.valueOf(this.markup.getExpressionString()));
            }
        }
        if (this.state != null && !this.state.isLiteralText()) {
            component.setValueExpression("state", this.state);
        }
        if (this.focusId != null) {
            component.setValueExpression("focusId", this.focusId);
        }
        if (this.height != null) {
            if (!this.height.isLiteralText()) {
                component.setValueExpression("height", this.height);
            } else {
                component.setHeight(Measure.valueOf(this.height.getExpressionString()));
            }
        }
        if (this.width != null) {
            if (!this.width.isLiteralText()) {
                component.setValueExpression("width", this.width);
            } else {
                component.setWidth(Measure.valueOf(this.width.getExpressionString()));
            }
        }
        if (this.label != null) {
            component.setValueExpression("label", this.label);
        }
        if (this.applicationIcon != null) {
            component.setValueExpression("applicationIcon", this.applicationIcon);
        }
    }

    public ValueExpression getMarkup() {
        return this.markup;
    }

    public void setMarkup(ValueExpression markup) {
        this.markup = markup;
    }

    public ValueExpression getState() {
        return this.state;
    }

    public void setState(ValueExpression state) {
        this.state = state;
    }

    public ValueExpression getFocusId() {
        return this.focusId;
    }

    public void setFocusId(ValueExpression focusId) {
        this.focusId = focusId;
    }

    public ValueExpression getHeight() {
        return this.height;
    }

    public void setHeight(ValueExpression height) {
        this.height = height;
    }

    public ValueExpression getWidth() {
        return this.width;
    }

    public void setWidth(ValueExpression width) {
        this.width = width;
    }

    public ValueExpression getLabel() {
        return this.label;
    }

    public void setLabel(ValueExpression label) {
        this.label = label;
    }

    public ValueExpression getApplicationIcon() {
        return this.applicationIcon;
    }

    public void setApplicationIcon(ValueExpression applicationIcon) {
        this.applicationIcon = applicationIcon;
    }

    public void release() {
        super.release();
        this.markup = null;
        this.state = null;
        this.focusId = null;
        this.height = null;
        this.width = null;
        this.label = null;
        this.applicationIcon = null;
    }
}

