/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib;

import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UIDatePicker;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.taglib.TobagoELTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatePickerTag
extends TobagoELTag {
    private static final Logger LOG = LoggerFactory.getLogger(DatePickerTag.class);
    private ValueExpression markup;
    private String forComponent;
    private ValueExpression tabIndex;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.DatePicker";
    }

    public String getRendererType() {
        return "DatePicker";
    }

    protected void setProperties(UIComponent uiComponent) {
        super.setProperties(uiComponent);
        UIDatePicker component = (UIDatePicker)uiComponent;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (this.markup != null) {
            if (!this.markup.isLiteralText()) {
                component.setValueExpression("markup", this.markup);
            } else {
                component.setMarkup(Markup.valueOf(this.markup.getExpressionString()));
            }
        }
        if (this.forComponent != null) {
            component.setFor(this.forComponent);
        }
        if (this.tabIndex != null) {
            if (!this.tabIndex.isLiteralText()) {
                component.setValueExpression("tabIndex", this.tabIndex);
            } else {
                component.setTabIndex(Integer.parseInt(this.tabIndex.getExpressionString()));
            }
        }
    }

    public ValueExpression getMarkup() {
        return this.markup;
    }

    public void setMarkup(ValueExpression markup) {
        this.markup = markup;
    }

    public String getFor() {
        return this.forComponent;
    }

    public void setFor(String forComponent) {
        this.forComponent = forComponent;
    }

    public ValueExpression getTabIndex() {
        return this.tabIndex;
    }

    public void setTabIndex(ValueExpression tabIndex) {
        this.tabIndex = tabIndex;
    }

    public void release() {
        super.release();
        this.markup = null;
        this.forComponent = null;
        this.tabIndex = null;
    }
}

