/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib;

import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UICell;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.taglib.TobagoELTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CellTag
extends TobagoELTag {
    private static final Logger LOG = LoggerFactory.getLogger(CellTag.class);
    private ValueExpression markup;
    private ValueExpression scrollbars;
    private ValueExpression spanX;
    private ValueExpression spanY;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.Cell";
    }

    public String getRendererType() {
        return "Cell";
    }

    protected void setProperties(UIComponent uiComponent) {
        super.setProperties(uiComponent);
        UICell component = (UICell)uiComponent;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (this.markup != null) {
            if (!this.markup.isLiteralText()) {
                component.setValueExpression("markup", this.markup);
            } else {
                component.setMarkup(Markup.valueOf(this.markup.getExpressionString()));
            }
        }
        if (this.scrollbars != null) {
            component.setValueExpression("scrollbars", this.scrollbars);
        }
        if (this.spanX != null) {
            if (!this.spanX.isLiteralText()) {
                component.setValueExpression("spanX", this.spanX);
            } else {
                component.setSpanX(Integer.parseInt(this.spanX.getExpressionString()));
            }
        }
        if (this.spanY != null) {
            if (!this.spanY.isLiteralText()) {
                component.setValueExpression("spanY", this.spanY);
            } else {
                component.setSpanY(Integer.parseInt(this.spanY.getExpressionString()));
            }
        }
    }

    public ValueExpression getMarkup() {
        return this.markup;
    }

    public void setMarkup(ValueExpression markup) {
        this.markup = markup;
    }

    public ValueExpression getScrollbars() {
        return this.scrollbars;
    }

    public void setScrollbars(ValueExpression scrollbars) {
        this.scrollbars = scrollbars;
    }

    public ValueExpression getSpanX() {
        return this.spanX;
    }

    public void setSpanX(ValueExpression spanX) {
        this.spanX = spanX;
    }

    public ValueExpression getSpanY() {
        return this.spanY;
    }

    public void setSpanY(ValueExpression spanY) {
        this.spanY = spanY;
    }

    public void release() {
        super.release();
        this.markup = null;
        this.scrollbars = null;
        this.spanX = null;
        this.spanY = null;
    }
}

