/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.lifecycle;

import java.util.ArrayList;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import org.apache.myfaces.tobago.internal.lifecycle.ApplyRequestValuesExecutor;
import org.apache.myfaces.tobago.internal.lifecycle.InvokeApplicationExecutor;
import org.apache.myfaces.tobago.internal.lifecycle.PhaseExecutor;
import org.apache.myfaces.tobago.internal.lifecycle.PhaseListenerManager;
import org.apache.myfaces.tobago.internal.lifecycle.ProcessValidationsExecutor;
import org.apache.myfaces.tobago.internal.lifecycle.RenderResponseExecutor;
import org.apache.myfaces.tobago.internal.lifecycle.RestoreViewExecutor;
import org.apache.myfaces.tobago.internal.lifecycle.UpdateModelValuesExecutor;
import org.apache.myfaces.tobago.util.DebugUtils;
import org.apache.myfaces.tobago.util.FacesVersion;
import org.apache.myfaces.tobago.util.MessageUtils;
import org.apache.myfaces.tobago.util.RequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TobagoLifecycle
extends Lifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(TobagoLifecycle.class);
    public static final String VIEW_ROOT_KEY = TobagoLifecycle.class.getName() + ".VIEW_ROOT_KEY";
    public static final String FACES_MESSAGES_KEY = TobagoLifecycle.class.getName() + ".FACES_MESSAGES_KEY";
    private PhaseExecutor[] lifecycleExecutors;
    private PhaseExecutor renderExecutor;
    private final List<PhaseListener> phaseListenerList = new ArrayList<PhaseListener>();
    private PhaseListener[] phaseListenerArray = null;

    public TobagoLifecycle() {
        this.lifecycleExecutors = new PhaseExecutor[]{new RestoreViewExecutor(), new ApplyRequestValuesExecutor(), new ProcessValidationsExecutor(), new UpdateModelValuesExecutor(), new InvokeApplicationExecutor()};
        this.renderExecutor = new RenderResponseExecutor();
    }

    public void execute(FacesContext context) throws FacesException {
        PhaseListenerManager phaseListenerMgr = new PhaseListenerManager(this, context, this.getPhaseListeners());
        RequestUtils.ensureEncoding((FacesContext)context);
        for (PhaseExecutor executor : this.lifecycleExecutors) {
            if (!this.executePhase(context, executor, phaseListenerMgr)) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executePhase(FacesContext facesContext, PhaseExecutor executor, PhaseListenerManager phaseListenerMgr) throws FacesException {
        boolean skipFurtherProcessing;
        block14: {
            skipFurtherProcessing = false;
            if (LOG.isTraceEnabled()) {
                LOG.trace("entering " + executor.getPhase() + " in " + TobagoLifecycle.class.getName());
            }
            try {
                phaseListenerMgr.informPhaseListenersBefore(executor.getPhase());
                if (this.isResponseComplete(facesContext, executor.getPhase(), true)) {
                    boolean bl = true;
                    return bl;
                }
                if (this.shouldRenderResponse(facesContext, executor.getPhase(), true)) {
                    skipFurtherProcessing = true;
                }
                if (executor.execute(facesContext)) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (RuntimeException e) {
                if (FacesVersion.supports20()) {
                    MessageUtils.publishException((Throwable)e, (PhaseId)executor.getPhase(), (FacesContext)facesContext);
                    break block14;
                }
                throw e;
            }
            finally {
                phaseListenerMgr.informPhaseListenersAfter(executor.getPhase());
            }
        }
        if (FacesVersion.supports20()) {
            MessageUtils.handleExceptions((FacesContext)facesContext);
        }
        if (this.isResponseComplete(facesContext, executor.getPhase(), false) || this.shouldRenderResponse(facesContext, executor.getPhase(), false)) {
            skipFurtherProcessing = true;
        }
        if (!skipFurtherProcessing && LOG.isTraceEnabled()) {
            LOG.trace("exiting " + executor.getPhase() + " in " + TobagoLifecycle.class.getName());
        }
        return skipFurtherProcessing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(FacesContext facesContext) throws FacesException {
        block12: {
            if (this.isResponseComplete(facesContext, this.renderExecutor.getPhase(), true)) {
                return;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("entering " + this.renderExecutor.getPhase() + " in " + TobagoLifecycle.class.getName());
            }
            PhaseListenerManager phaseListenerMgr = new PhaseListenerManager(this, facesContext, this.getPhaseListeners());
            try {
                phaseListenerMgr.informPhaseListenersBefore(this.renderExecutor.getPhase());
                if (this.isResponseComplete(facesContext, this.renderExecutor.getPhase(), true)) {
                    return;
                }
                this.renderExecutor.execute(facesContext);
            }
            catch (RuntimeException e) {
                if (FacesVersion.supports20()) {
                    MessageUtils.publishException((Throwable)e, (PhaseId)this.renderExecutor.getPhase(), (FacesContext)facesContext);
                    break block12;
                }
                throw e;
            }
            finally {
                phaseListenerMgr.informPhaseListenersAfter(this.renderExecutor.getPhase());
            }
        }
        if (FacesVersion.supports20()) {
            MessageUtils.handleExceptions((FacesContext)facesContext);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(DebugUtils.toString((UIComponent)facesContext.getViewRoot(), 0));
            LOG.trace("exiting " + this.renderExecutor.getPhase() + " in " + TobagoLifecycle.class.getName());
        }
    }

    private boolean isResponseComplete(FacesContext facesContext, PhaseId phase, boolean before) {
        boolean flag = false;
        if (facesContext.getResponseComplete()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("exiting from lifecycle.execute in " + phase + " because getResponseComplete is true from one of the " + (before ? "before" : "after") + " listeners");
            }
            flag = true;
        }
        return flag;
    }

    private boolean shouldRenderResponse(FacesContext facesContext, PhaseId phase, boolean before) {
        boolean flag = false;
        if (facesContext.getRenderResponse()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("exiting from lifecycle.execute in " + phase + " because getRenderResponse is true from one of the " + (before ? "before" : "after") + " listeners");
            }
            flag = true;
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPhaseListener(PhaseListener phaseListener) {
        if (phaseListener == null) {
            throw new NullPointerException("PhaseListener must not be null.");
        }
        List<PhaseListener> list = this.phaseListenerList;
        synchronized (list) {
            this.phaseListenerList.add(phaseListener);
            this.phaseListenerArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePhaseListener(PhaseListener phaseListener) {
        if (phaseListener == null) {
            throw new NullPointerException("PhaseListener must not be null.");
        }
        List<PhaseListener> list = this.phaseListenerList;
        synchronized (list) {
            this.phaseListenerList.remove(phaseListener);
            this.phaseListenerArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PhaseListener[] getPhaseListeners() {
        List<PhaseListener> list = this.phaseListenerList;
        synchronized (list) {
            if (this.phaseListenerArray == null) {
                this.phaseListenerArray = this.phaseListenerList.toArray(new PhaseListener[this.phaseListenerList.size()]);
            }
            return this.phaseListenerArray;
        }
    }
}

