/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.lifecycle;

import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PhaseListenerManager {
    private static final Logger LOG = LoggerFactory.getLogger(PhaseListenerManager.class);
    private Lifecycle lifecycle;
    private FacesContext facesContext;
    private PhaseListener[] phaseListeners;
    private Map<PhaseId, boolean[]> listenerSuccessMap = new HashMap<PhaseId, boolean[]>();

    PhaseListenerManager(Lifecycle lifecycle, FacesContext facesContext, PhaseListener[] phaseListeners) {
        this.lifecycle = lifecycle;
        this.facesContext = facesContext;
        this.phaseListeners = phaseListeners;
    }

    private boolean isListenerForThisPhase(PhaseListener phaseListener, PhaseId phaseId) {
        int listenerPhaseId = phaseListener.getPhaseId().getOrdinal();
        return listenerPhaseId == PhaseId.ANY_PHASE.getOrdinal() || listenerPhaseId == phaseId.getOrdinal();
    }

    void informPhaseListenersBefore(PhaseId phaseId) {
        boolean[] beforePhaseSuccess = new boolean[this.phaseListeners.length];
        this.listenerSuccessMap.put(phaseId, beforePhaseSuccess);
        if (this.phaseListeners.length == 0) {
            return;
        }
        PhaseEvent event = new PhaseEvent(this.facesContext, phaseId, this.lifecycle);
        for (int i = 0; i < this.phaseListeners.length; ++i) {
            PhaseListener phaseListener = this.phaseListeners[i];
            if (!this.isListenerForThisPhase(phaseListener, phaseId)) continue;
            try {
                phaseListener.beforePhase(event);
                beforePhaseSuccess[i] = true;
                continue;
            }
            catch (Exception e) {
                beforePhaseSuccess[i] = false;
                LOG.error("Exception in PhaseListener " + phaseId.toString() + " beforePhase.", (Throwable)e);
                return;
            }
        }
    }

    void informPhaseListenersAfter(PhaseId phaseId) {
        boolean[] beforePhaseSuccess = this.listenerSuccessMap.get(phaseId);
        if (this.phaseListeners.length == 0) {
            return;
        }
        PhaseEvent event = new PhaseEvent(this.facesContext, phaseId, this.lifecycle);
        for (int i = this.phaseListeners.length - 1; i >= 0; --i) {
            PhaseListener phaseListener = this.phaseListeners[i];
            if (!this.isListenerForThisPhase(phaseListener, phaseId) || !beforePhaseSuccess[i]) continue;
            try {
                phaseListener.afterPhase(event);
                continue;
            }
            catch (Exception e) {
                LOG.error("Exception in PhaseListener " + phaseId.toString() + " afterPhase", (Throwable)e);
            }
        }
    }
}

