/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.layout;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.LayoutBox;
import org.apache.myfaces.tobago.layout.LayoutComponent;
import org.apache.myfaces.tobago.layout.LayoutContainer;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.layout.Orientation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LayoutUtils {
    private static final Logger LOG = LoggerFactory.getLogger(LayoutUtils.class);
    private static final Pattern TOKEN_PATTERN = Pattern.compile("^(\\d*px|\\d*\\*|\\d*%|auto|fixed)$");

    private LayoutUtils() {
    }

    public static boolean checkTokens(String columns) {
        StringTokenizer st = new StringTokenizer(columns, ";");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (TOKEN_PATTERN.matcher(token).matches()) continue;
            return false;
        }
        return true;
    }

    public static List<LayoutComponent> findLayoutChildren(LayoutContainer container) {
        ArrayList<LayoutComponent> result = new ArrayList<LayoutComponent>();
        LayoutUtils.addLayoutChildren((UIComponent)container, result);
        return result;
    }

    private static void addLayoutChildren(UIComponent component, List<LayoutComponent> result) {
        for (UIComponent child : component.getChildren()) {
            if (child instanceof LayoutComponent) {
                result.add((LayoutComponent)child);
                continue;
            }
            LayoutUtils.addLayoutChildren(child, result);
        }
    }

    public static Measure getBorderEnd(Orientation orientation, LayoutBox container) {
        return orientation == Orientation.HORIZONTAL ? container.getBorderRight() : container.getBorderBottom();
    }

    public static Measure getBorderBegin(Orientation orientation, LayoutBox container) {
        return orientation == Orientation.HORIZONTAL ? container.getBorderLeft() : container.getBorderTop();
    }

    public static Measure getPaddingEnd(Orientation orientation, LayoutBox container) {
        return orientation == Orientation.HORIZONTAL ? container.getPaddingRight() : container.getPaddingBottom();
    }

    public static Measure getPaddingBegin(Orientation orientation, LayoutBox container) {
        return orientation == Orientation.HORIZONTAL ? container.getPaddingLeft() : container.getPaddingTop();
    }

    public static Measure getCurrentSize(Orientation orientation, LayoutBase component) {
        return orientation == Orientation.HORIZONTAL ? component.getCurrentWidth() : component.getCurrentHeight();
    }

    public static void setCurrentSize(Orientation orientation, LayoutBase component, Measure size) {
        if (orientation == Orientation.HORIZONTAL) {
            Measure width = component.getWidth();
            if (width != null) {
                size = width;
            } else {
                Measure minimumWidth;
                Measure maximumWidth = component.getMaximumWidth();
                if (size.greaterThan(maximumWidth)) {
                    size = maximumWidth;
                }
                if (size.lessThan(minimumWidth = component.getMinimumWidth())) {
                    size = minimumWidth;
                }
            }
            component.setCurrentWidth(size);
        } else {
            Measure height = component.getHeight();
            if (height != null) {
                size = height;
            } else {
                Measure minimumHeight;
                Measure maximumHeight = component.getMaximumHeight();
                if (size.greaterThan(maximumHeight)) {
                    size = maximumHeight;
                }
                if (size.lessThan(minimumHeight = component.getMinimumHeight())) {
                    size = minimumHeight;
                }
            }
            component.setCurrentHeight(size);
        }
    }
}

