/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.context;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import org.apache.myfaces.tobago.application.ProjectStage;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.ResourceManager;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.context.UserAgent;
import org.apache.myfaces.tobago.internal.config.TobagoConfigImpl;
import org.apache.myfaces.tobago.internal.context.ClientPropertiesKey;
import org.apache.myfaces.tobago.internal.context.ImageCacheKey;
import org.apache.myfaces.tobago.internal.context.JspCacheKey;
import org.apache.myfaces.tobago.internal.context.MeasureValue;
import org.apache.myfaces.tobago.internal.context.MiscCacheKey;
import org.apache.myfaces.tobago.internal.context.PropertyCacheKey;
import org.apache.myfaces.tobago.internal.context.RendererCacheKey;
import org.apache.myfaces.tobago.internal.context.StringValue;
import org.apache.myfaces.tobago.internal.context.ThemeConfigCacheKey;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceManagerImpl
implements ResourceManager {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceManagerImpl.class);
    private static final String PROPERTY = "property";
    private static final String JSP = "jsp";
    private static final String TAG = "tag";
    private static final String MINIMIZE_SUFFIX = ".min";
    private boolean production;
    private final Map<String, String> resourceList = new ConcurrentHashMap<String, String>(100, 0.75f, 1);
    private final Map<RendererCacheKey, Renderer> rendererCache = new ConcurrentHashMap<RendererCacheKey, Renderer>(100, 0.75f, 1);
    private final Map<ImageCacheKey, StringValue> imageCache = new ConcurrentHashMap<ImageCacheKey, StringValue>(100, 0.75f, 1);
    private final Map<JspCacheKey, String> jspCache = new ConcurrentHashMap<JspCacheKey, String>(100, 0.75f, 1);
    private final Map<MiscCacheKey, String[]> miscCache = new ConcurrentHashMap<MiscCacheKey, String[]>(100, 0.75f, 1);
    private final Map<PropertyCacheKey, StringValue> propertyCache = new ConcurrentHashMap<PropertyCacheKey, StringValue>(100, 0.75f, 1);
    private final Map<ThemeConfigCacheKey, MeasureValue> themeCache = new ConcurrentHashMap<ThemeConfigCacheKey, MeasureValue>(100, 0.75f, 1);
    private TobagoConfigImpl tobagoConfig;

    public ResourceManagerImpl(TobagoConfigImpl tobagoConfig) {
        this.tobagoConfig = tobagoConfig;
        this.production = tobagoConfig.getProjectStage() == ProjectStage.Production;
    }

    public void add(String resourceKey) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("adding resourceKey = '{}'", (Object)resourceKey);
        }
        this.resourceList.put(resourceKey, "");
    }

    public void add(String resourceKey, String value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("adding resourceKey = '{}' value= '{}'", (Object)resourceKey, (Object)value);
        }
        this.resourceList.put(resourceKey, value);
    }

    @Deprecated
    public String getJsp(UIViewRoot viewRoot, String name) {
        String result = null;
        if (name != null) {
            ClientPropertiesKey clientKey = ClientPropertiesKey.get(FacesContext.getCurrentInstance());
            JspCacheKey cacheKey = new JspCacheKey(clientKey, name);
            result = this.jspCache.get(cacheKey);
            if (result != null) {
                return result;
            }
            try {
                result = (String)this.getPaths(clientKey, "", JSP, name, "", false, true, true, null, true, false).get(0);
                this.jspCache.put(cacheKey, result);
            }
            catch (Exception e) {
                LOG.error("name = '" + name + "' clientProperties = '" + clientKey.toString() + "'", (Throwable)e);
            }
        }
        return result;
    }

    @Deprecated
    public String getProperty(UIViewRoot viewRoot, String bundle, String propertyKey) {
        return this.getProperty(FacesContext.getCurrentInstance(), bundle, propertyKey);
    }

    public String getProperty(FacesContext facesContext, String bundle, String propertyKey) {
        if (bundle != null && propertyKey != null) {
            ClientPropertiesKey clientKey = ClientPropertiesKey.get(facesContext);
            PropertyCacheKey cacheKey = new PropertyCacheKey(clientKey, bundle, propertyKey);
            StringValue result = this.propertyCache.get(cacheKey);
            if (result == null) {
                List properties = this.getPaths(clientKey, "", PROPERTY, bundle, "", false, true, false, propertyKey, true, false);
                result = properties != null ? new StringValue((String)properties.get(0)) : StringValue.NULL;
                this.propertyCache.put(cacheKey, result);
            }
            return result.getValue();
        }
        return null;
    }

    @Deprecated
    public Renderer getRenderer(UIViewRoot viewRoot, String rendererType) {
        return this.getRenderer(FacesContext.getCurrentInstance(), rendererType);
    }

    public Renderer getRenderer(FacesContext facesContext, String rendererType) {
        Renderer renderer = null;
        if (rendererType != null) {
            ClientPropertiesKey clientKey = ClientPropertiesKey.get(facesContext);
            RendererCacheKey cacheKey = new RendererCacheKey(clientKey, rendererType);
            renderer = this.rendererCache.get(cacheKey);
            if (renderer != null) {
                return renderer;
            }
            String simpleClassName = null;
            try {
                simpleClassName = this.getRendererClassName(rendererType);
                List classes = this.getPaths(clientKey, "", TAG, simpleClassName, "", false, true, true, null, false, false);
                if (classes != null && !classes.isEmpty()) {
                    Class clazz = (Class)classes.get(0);
                    renderer = (Renderer)clazz.newInstance();
                    this.rendererCache.put(cacheKey, renderer);
                } else {
                    LOG.error("Don't find any RendererClass for " + simpleClassName + ". Please check you configuration.");
                }
            }
            catch (InstantiationException e) {
                LOG.error("name = '" + simpleClassName + "' clientProperties = '" + clientKey.toString() + "'", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error("name = '" + simpleClassName + "' clientProperties = '" + clientKey.toString() + "'", (Throwable)e);
            }
        }
        return renderer;
    }

    @Deprecated
    public String[] getScripts(UIViewRoot viewRoot, String name) {
        return this.getScripts(FacesContext.getCurrentInstance(), name);
    }

    public String[] getScripts(FacesContext facesContext, String name) {
        return this.getStrings(facesContext, name, null);
    }

    @Deprecated
    public String[] getStyles(UIViewRoot viewRoot, String name) {
        return this.getStyles(FacesContext.getCurrentInstance(), name);
    }

    public String[] getStyles(FacesContext facesContext, String name) {
        return this.getStrings(facesContext, name, null);
    }

    @Deprecated
    public String getThemeProperty(UIViewRoot viewRoot, String bundle, String propertyKey) {
        if (bundle != null && propertyKey != null) {
            ClientPropertiesKey clientKey = ClientPropertiesKey.get(FacesContext.getCurrentInstance());
            PropertyCacheKey cacheKey = new PropertyCacheKey(clientKey, bundle, propertyKey);
            StringValue result = this.propertyCache.get(cacheKey);
            if (result == null) {
                List properties = this.getPaths(clientKey, "", PROPERTY, bundle, "", false, true, false, propertyKey, true, true);
                result = properties != null ? new StringValue((String)properties.get(0)) : StringValue.NULL;
                this.propertyCache.put(cacheKey, result);
            }
            return result.getValue();
        }
        return null;
    }

    public Measure getThemeMeasure(FacesContext facesContext, Configurable configurable, String name) {
        return this.getThemeMeasure(facesContext, configurable.getRendererType(), configurable.getCurrentMarkup(), name);
    }

    public Measure getThemeMeasure(FacesContext facesContext, String rendererType, Markup markup, String name) {
        ClientPropertiesKey clientKey = ClientPropertiesKey.get(facesContext);
        ThemeConfigCacheKey cacheKey = new ThemeConfigCacheKey(clientKey, rendererType, markup, name);
        MeasureValue result = this.themeCache.get(cacheKey);
        if (result == null) {
            List properties = this.getPaths(clientKey, "", PROPERTY, "tobago-theme-config", "", false, true, false, rendererType + "." + name, true, true);
            Measure measure = null;
            if (properties != null) {
                measure = Measure.valueOf(properties.get(0));
            }
            if (markup != null) {
                for (String m : markup) {
                    List mProperties = this.getPaths(clientKey, "", PROPERTY, "tobago-theme-config", "", false, true, false, rendererType + "[" + m + "]" + "." + name, true, true);
                    if (mProperties == null) continue;
                    Measure summand = Measure.valueOf(mProperties.get(0));
                    measure = summand.add(measure);
                }
            }
            result = measure != null ? new MeasureValue(measure) : MeasureValue.NULL;
            this.themeCache.put(cacheKey, result);
        }
        return result.getValue();
    }

    @Deprecated
    public String getImage(UIViewRoot viewRoot, String name) {
        return this.getImage(FacesContext.getCurrentInstance(), name);
    }

    public String getImage(FacesContext facesContext, String name) {
        return this.getImage(facesContext, name, false);
    }

    @Deprecated
    public String getImage(UIViewRoot viewRoot, String name, boolean ignoreMissing) {
        return this.getImage(FacesContext.getCurrentInstance(), name, ignoreMissing);
    }

    public String getImage(FacesContext facesContext, String name, boolean ignoreMissing) {
        if (name != null) {
            ClientPropertiesKey clientKey;
            ImageCacheKey cacheKey;
            StringValue result;
            int dot = name.lastIndexOf(46);
            if (dot == -1) {
                dot = name.length();
            }
            if ((result = this.imageCache.get(cacheKey = new ImageCacheKey(clientKey = ClientPropertiesKey.get(facesContext), name))) == null) {
                List paths = this.getPaths(clientKey, "", null, name.substring(0, dot), name.substring(dot), false, true, true, null, true, ignoreMissing);
                result = paths != null ? new StringValue((String)paths.get(0)) : StringValue.NULL;
                this.imageCache.put(cacheKey, result);
            }
            if (LOG.isDebugEnabled() && result.getValue() == null) {
                LOG.debug("Can't find image for \"{}\"", (Object)name);
            }
            return result.getValue();
        }
        return null;
    }

    private List getPaths(ClientPropertiesKey clientkey, String prefix, String subDir, String name, String suffix, boolean reverseOrder, boolean single, boolean returnKey, String key, boolean returnStrings, boolean ignoreMissing) {
        String path;
        ArrayList matches = new ArrayList();
        String contentType = clientkey.getContentType();
        Theme theme = clientkey.getTheme();
        UserAgent browser = clientkey.getUserAgent();
        List<String> locales = LocaleUtils.getLocaleSuffixList(clientkey.getLocale());
        for (String localeSuffix : locales) {
            boolean found;
            if (this.production) {
                path = this.makePath(name, MINIMIZE_SUFFIX, localeSuffix, suffix, key);
                found = this.checkPath(prefix, reverseOrder, returnKey, returnStrings, matches, path);
                if (found && (single || !returnStrings)) {
                    return matches;
                }
                if (found || !(found = this.checkPath(prefix, reverseOrder, returnKey, returnStrings, matches, path = this.makePath(name, null, localeSuffix, suffix, key))) || !single && returnStrings) continue;
                return matches;
            }
            path = this.makePath(name, null, localeSuffix, suffix, key);
            found = this.checkPath(prefix, reverseOrder, returnKey, returnStrings, matches, path);
            if (!found || !single && returnStrings) continue;
            return matches;
        }
        for (Theme themeName : theme.getFallbackList()) {
            for (String resourceDirectory : this.tobagoConfig.getResourceDirs()) {
                for (String browserType : browser.getFallbackList()) {
                    for (String localeSuffix : locales) {
                        boolean found;
                        if (this.production) {
                            path = this.makePath(resourceDirectory, contentType, themeName, browserType, subDir, name, MINIMIZE_SUFFIX, localeSuffix, suffix, key);
                            found = this.checkPath(prefix, reverseOrder, returnKey, returnStrings, matches, path);
                            if (found && (single || !returnStrings)) {
                                return matches;
                            }
                            if (found || !(found = this.checkPath(prefix, reverseOrder, returnKey, returnStrings, matches, path = this.makePath(resourceDirectory, contentType, themeName, browserType, subDir, name, null, localeSuffix, suffix, key))) || !single && returnStrings) continue;
                            return matches;
                        }
                        path = this.makePath(resourceDirectory, contentType, themeName, browserType, subDir, name, null, localeSuffix, suffix, key);
                        found = this.checkPath(prefix, reverseOrder, returnKey, returnStrings, matches, path);
                        if (!found || !single && returnStrings) continue;
                        return matches;
                    }
                }
            }
        }
        if (matches.isEmpty()) {
            if (!ignoreMissing) {
                LOG.error("Path not found, and no fallback. Using empty string.\nresourceDirs = '" + this.tobagoConfig.getResourceDirs() + "' contentType = '" + contentType + "' theme = '" + theme.getName() + "' browser = '" + browser + "' subDir = '" + subDir + "' name = '" + name + "' suffix = '" + suffix + "' key = '" + key + "'");
            }
            return null;
        }
        return matches;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkPath(String prefix, boolean reverseOrder, boolean returnKey, boolean returnStrings, List matches, String path) {
        if (returnStrings && this.resourceList.containsKey(path)) {
            String result;
            String string = result = returnKey ? prefix + path : prefix + this.resourceList.get(path);
            if (reverseOrder) {
                matches.add(0, result);
            } else {
                matches.add(result);
            }
            if (!LOG.isTraceEnabled()) return true;
            LOG.trace("testing path: {} *", (Object)path);
            return true;
        }
        if (!returnStrings) {
            try {
                path = path.substring(1).replace('/', '.');
                Class<?> clazz = Class.forName(path);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("testing path: " + path + " *");
                }
                matches.add(clazz);
                return true;
            }
            catch (ClassNotFoundException e) {
                if (!LOG.isTraceEnabled()) return false;
                LOG.trace("testing path: " + path);
                return false;
            }
        } else {
            if (!LOG.isTraceEnabled()) return false;
            LOG.trace("testing path: " + path);
        }
        return false;
    }

    private String makePath(String project, String language, Theme theme, String browser, String subDir, String name, String minimizeSuffix, String localeSuffix, String extension, String key) {
        StringBuilder searchtext = new StringBuilder(64);
        searchtext.append('/');
        searchtext.append(project);
        searchtext.append('/');
        searchtext.append(language);
        searchtext.append('/');
        searchtext.append(theme.getName());
        searchtext.append('/');
        searchtext.append(browser);
        if (subDir != null) {
            searchtext.append('/');
            searchtext.append(subDir);
        }
        searchtext.append('/');
        searchtext.append(name);
        if (minimizeSuffix != null) {
            searchtext.append(minimizeSuffix);
        }
        searchtext.append(localeSuffix);
        searchtext.append(extension);
        if (key != null) {
            searchtext.append('/');
            searchtext.append(key);
        }
        return searchtext.toString();
    }

    private String makePath(String name, String minimizeSuffix, String localeSuffix, String extension, String key) {
        StringBuilder searchtext = new StringBuilder(64);
        searchtext.append('/');
        searchtext.append(name);
        if (minimizeSuffix != null) {
            searchtext.append(minimizeSuffix);
        }
        searchtext.append(localeSuffix);
        searchtext.append(extension);
        if (key != null) {
            searchtext.append('/');
            searchtext.append(key);
        }
        return searchtext.toString();
    }

    private String getRendererClassName(String rendererType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("rendererType = '{}'", (Object)rendererType);
        }
        String name = "javax.faces.Text".equals(rendererType) ? "Out" : rendererType;
        if ((name = name + "Renderer").startsWith("javax.faces.")) {
            LOG.warn("patching renderer from {}", (Object)name);
            name = name.substring("javax.faces.".length());
            LOG.warn("patching renderer to {}", (Object)name);
        }
        return name;
    }

    private String[] getStrings(FacesContext facesContext, String name, String type) {
        String[] result = new String[]{};
        if (name != null) {
            ClientPropertiesKey key;
            MiscCacheKey miscKey;
            String[] cacheResult;
            int dot = name.lastIndexOf(46);
            if (dot == -1) {
                dot = name.length();
            }
            if ((cacheResult = this.miscCache.get(miscKey = new MiscCacheKey(key = ClientPropertiesKey.get(facesContext), name))) != null) {
                return cacheResult;
            }
            try {
                List matches = this.getPaths(key, "", type, name.substring(0, dot), name.substring(dot), true, false, true, null, true, false);
                if (matches != null) {
                    result = matches.toArray(new String[matches.size()]);
                }
                this.miscCache.put(miscKey, result);
            }
            catch (Exception e) {
                LOG.error("name = '" + name + "' clientProperties = '" + key.toString() + "'", (Throwable)e);
            }
        }
        return result;
    }
}

