/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.config;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.myfaces.tobago.application.ProjectStage;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.internal.config.RenderersConfig;
import org.apache.myfaces.tobago.internal.util.Deprecation;
import org.apache.myfaces.tobago.internal.util.JndiUtils;
import org.apache.myfaces.tobago.util.FacesVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TobagoConfigImpl
extends TobagoConfig {
    private static final Logger LOG = LoggerFactory.getLogger(TobagoConfigImpl.class);
    public static final String TOBAGO_CONFIG = "org.apache.myfaces.tobago.config.TobagoConfig";
    private List<Theme> supportedThemes;
    private List<String> supportedThemeNames = new ArrayList<String>();
    private Theme defaultTheme;
    private String defaultThemeName;
    private List<String> resourceDirs;
    private Map<String, Theme> availableThemes;
    private RenderersConfig renderersConfig;
    private ProjectStage projectStage;
    private boolean createSessionSecret = true;
    private boolean checkSessionSecret = true;
    private URL url;
    private Map<String, String> defaultValidatorInfo;

    public TobagoConfigImpl() {
        this.supportedThemes = new ArrayList<Theme>();
        this.resourceDirs = new ArrayList<String>();
    }

    public void addSupportedThemeName(String name) {
        this.supportedThemeNames.add(name);
    }

    public void resolveThemes() {
        if (this.defaultThemeName != null) {
            this.defaultTheme = this.availableThemes.get(this.defaultThemeName);
            this.checkThemeIsAvailable(this.defaultThemeName, this.defaultTheme);
            if (LOG.isDebugEnabled()) {
                LOG.debug("name = '{}'", (Object)this.defaultThemeName);
                LOG.debug("defaultTheme = '{}'", (Object)this.defaultTheme);
            }
        } else {
            int deep = 0;
            for (Map.Entry<String, Theme> entry : this.availableThemes.entrySet()) {
                Theme theme = entry.getValue();
                if (theme.getFallbackList().size() <= deep) continue;
                this.defaultTheme = theme;
                deep = theme.getFallbackList().size();
            }
            if (this.defaultTheme == null) {
                String error = "Did not found any theme! Please ensure you have a tobago-config.xml with a theme-definition or a tobago-theme.xml file (deprecated) in your theme JAR. Please add a theme JAR to your WEB-INF/lib";
                LOG.error(error);
                throw new RuntimeException(error);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Using default Theme {}", (Object)this.defaultTheme.getName());
            }
        }
        if (!this.supportedThemeNames.isEmpty()) {
            for (String name : this.supportedThemeNames) {
                Theme theme = this.availableThemes.get(name);
                this.checkThemeIsAvailable(name, theme);
                this.supportedThemes.add(theme);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("name = '{}'", (Object)name);
                LOG.debug("supportedThemes.last() = '{}'", (Object)this.supportedThemes.get(this.supportedThemes.size() - 1));
            }
        }
    }

    private void checkThemeIsAvailable(String name, Theme theme) {
        if (theme == null) {
            String error = "Theme not found! name: '" + name + "'. " + "Please ensure you have a tobago-config.xml with a theme-definition " + "or a tobago-theme.xml file (deprecated) in your " + "theme jar. Found the following themes: " + this.availableThemes.keySet();
            LOG.error(error);
            throw new RuntimeException(error);
        }
    }

    @Override
    public Theme getTheme(String name) {
        if (name == null) {
            LOG.debug("searching theme: null");
            return this.defaultTheme;
        }
        if (this.defaultTheme.getName().equals(name)) {
            return this.defaultTheme;
        }
        for (Theme theme : this.supportedThemes) {
            if (!theme.getName().equals(name)) continue;
            return theme;
        }
        LOG.debug("searching theme '{}' not found. Using default: {}", (Object)name, (Object)this.defaultTheme);
        return this.defaultTheme;
    }

    public void setDefaultThemeName(String defaultThemeName) {
        this.defaultThemeName = defaultThemeName;
    }

    @Override
    public List<Theme> getSupportedThemes() {
        return Collections.unmodifiableList(this.supportedThemes);
    }

    public void addResourceDir(String resourceDir) {
        if (!this.resourceDirs.contains(resourceDir)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("adding resourceDir = '{}'", (Object)resourceDir);
            }
            this.resourceDirs.add(0, resourceDir);
        }
    }

    public List<String> getResourceDirs() {
        return this.resourceDirs;
    }

    @Override
    @Deprecated
    public boolean isAjaxEnabled() {
        Deprecation.LOG.warn("Ajax is always enabled!");
        return true;
    }

    @Override
    public Theme getDefaultTheme() {
        return this.defaultTheme;
    }

    public void setAvailableThemes(Map<String, Theme> availableThemes) {
        this.availableThemes = availableThemes;
        for (Theme theme : this.availableThemes.values()) {
            this.addResourceDir(theme.getResourcePath());
        }
    }

    public RenderersConfig getRenderersConfig() {
        return this.renderersConfig;
    }

    public void setRenderersConfig(RenderersConfig renderersConfig) {
        this.renderersConfig = renderersConfig;
    }

    @Override
    public ProjectStage getProjectStage() {
        return this.projectStage;
    }

    public void initProjectState(ServletContext servletContext) {
        String stageName = null;
        try {
            InitialContext ctx = new InitialContext();
            Object obj = JndiUtils.getJndiProperty((Context)ctx, "jsf", "ProjectStage");
            if (obj != null) {
                if (obj instanceof String) {
                    stageName = (String)obj;
                } else {
                    LOG.warn("JNDI lookup for key {} should return a java.lang.String value", (Object)"java:comp/env/jsf/ProjectStage");
                }
            }
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (stageName == null) {
            stageName = servletContext.getInitParameter("javax.faces.PROJECT_STAGE");
        }
        if (stageName == null) {
            stageName = System.getProperty("org.apache.myfaces.PROJECT_STAGE");
        }
        if (stageName != null) {
            try {
                this.projectStage = ProjectStage.valueOf(stageName);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Couldn't discover the current project stage", (Throwable)e);
            }
        }
        if (this.projectStage == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Couldn't discover the current project stage, using {}", (Object)ProjectStage.Production);
            }
            this.projectStage = ProjectStage.Production;
        }
    }

    public synchronized void initDefaultValidatorInfo() {
        block6: {
            if (FacesVersion.supports20()) {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                if (facesContext != null) {
                    try {
                        Application application = facesContext.getApplication();
                        Map map = (Map)PropertyUtils.getProperty((Object)application, (String)"defaultValidatorInfo");
                        if (application != null && map.size() > 0) {
                            this.defaultValidatorInfo = Collections.unmodifiableMap(map);
                            break block6;
                        }
                        this.defaultValidatorInfo = Collections.emptyMap();
                    }
                    catch (Exception e) {
                        LOG.error("Can't initialize default validators.", (Throwable)e);
                        this.defaultValidatorInfo = Collections.emptyMap();
                    }
                }
            } else {
                this.defaultValidatorInfo = Collections.emptyMap();
            }
        }
    }

    @Override
    public boolean isCreateSessionSecret() {
        return this.createSessionSecret;
    }

    public void setCreateSessionSecret(boolean createSessionSecret) {
        this.createSessionSecret = createSessionSecret;
    }

    @Override
    public boolean isCheckSessionSecret() {
        return this.checkSessionSecret;
    }

    public void setCheckSessionSecret(boolean checkSessionSecret) {
        this.checkSessionSecret = checkSessionSecret;
    }

    public Map<String, String> getDefaultValidatorInfo() {
        if (this.defaultValidatorInfo == null) {
            this.initDefaultValidatorInfo();
        }
        return this.defaultValidatorInfo;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TobagoConfigImpl{");
        builder.append("\nsupportedThemes=[");
        for (Theme supportedTheme : this.supportedThemes) {
            builder.append(supportedTheme.getName());
            builder.append(", ");
        }
        builder.append("], \ndefaultTheme=");
        builder.append(this.defaultTheme.getName());
        builder.append(", \nresourceDirs=");
        builder.append(this.resourceDirs);
        builder.append(", \navailableThemes=");
        builder.append(this.availableThemes.keySet());
        builder.append(", \nprojectStage=");
        builder.append((Object)this.projectStage);
        builder.append(", \ncreateSessionSecret=");
        builder.append(this.createSessionSecret);
        builder.append(", \ncheckSessionSecret=");
        builder.append(this.checkSessionSecret);
        builder.append(", \nurl=");
        builder.append(this.url);
        builder.append(", \nthemes=");
        HashSet<Theme> all = new HashSet<Theme>(this.availableThemes.values());
        builder.append(all);
        builder.append('}');
        return builder.toString();
    }
}

