/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.config;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.myfaces.tobago.context.ThemeImpl;
import org.apache.myfaces.tobago.internal.config.RenderersConfig;
import org.apache.myfaces.tobago.internal.util.Deprecation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TobagoConfigFragment {
    private static final Logger LOG = LoggerFactory.getLogger(TobagoConfigFragment.class);
    private String name;
    private List<String> before = new ArrayList<String>();
    private List<String> after = new ArrayList<String>();
    private List<String> supportedThemeNames = new ArrayList<String>();
    private String defaultThemeName;
    private List<String> resourceDirs = new ArrayList<String>();
    private RenderersConfig renderersConfig;
    private Boolean createSessionSecret;
    private Boolean checkSessionSecret;
    private List<ThemeImpl> themeDefinitions = new ArrayList<ThemeImpl>();
    private URL url;

    public void addSupportedThemeName(String name) {
        this.supportedThemeNames.add(name);
    }

    public List<String> getSupportedThemeNames() {
        return this.supportedThemeNames;
    }

    public String getDefaultThemeName() {
        return this.defaultThemeName;
    }

    public void setDefaultThemeName(String defaultThemeName) {
        this.defaultThemeName = defaultThemeName;
    }

    public void addResourceDir(String resourceDir) {
        if (!this.resourceDirs.contains(resourceDir)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("adding resourceDir = '{}'", (Object)resourceDir);
            }
            this.resourceDirs.add(resourceDir);
        }
    }

    public List<String> getResourceDirs() {
        return this.resourceDirs;
    }

    @Deprecated
    public void setAjaxEnabled(String value) {
        Deprecation.LOG.error("Ajax is always enabled!");
    }

    public RenderersConfig getRenderersConfig() {
        return this.renderersConfig;
    }

    public void setRenderersConfig(RenderersConfig renderersConfig) {
        this.renderersConfig = renderersConfig;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getBefore() {
        return this.before;
    }

    public void addBefore(String name) {
        this.before.add(name);
    }

    public List<String> getAfter() {
        return this.after;
    }

    public void addAfter(String name) {
        this.after.add(name);
    }

    public void addThemeDefinition(ThemeImpl theme) {
        this.themeDefinitions.add(theme);
    }

    public List<ThemeImpl> getThemeDefinitions() {
        return this.themeDefinitions;
    }

    public Boolean getCreateSessionSecret() {
        return this.createSessionSecret;
    }

    public void setCreateSessionSecret(String createSessionSecret) {
        this.createSessionSecret = Boolean.valueOf(createSessionSecret);
    }

    public Boolean getCheckSessionSecret() {
        return this.checkSessionSecret;
    }

    public void setCheckSessionSecret(String checkSessionSecret) {
        this.checkSessionSecret = Boolean.valueOf(checkSessionSecret);
    }

    @Deprecated
    public void setFixResourceOrder(String value) {
        Deprecation.LOG.error("Config fix-resource-order not longer supported. (Is always activated).");
    }

    @Deprecated
    public void setFixLayoutTransparency(String value) {
        Deprecation.LOG.error("Config fix-layout-transparency not longer supported. (Is always activated).");
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public String toString() {
        return this.name != null ? this.name : "(id=" + System.identityHashCode(this) + ")";
    }
}

