/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.config;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.myfaces.tobago.context.ThemeImpl;
import org.apache.myfaces.tobago.internal.config.ThemeParser;
import org.apache.myfaces.tobago.internal.config.TobagoConfigFragment;
import org.apache.myfaces.tobago.internal.config.TobagoConfigImpl;
import org.apache.myfaces.tobago.internal.config.TobagoConfigParser;
import org.apache.myfaces.tobago.internal.config.TobagoConfigSorter;
import org.apache.myfaces.tobago.internal.context.ResourceManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class TobagoConfigBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(TobagoConfigBuilder.class);
    private static final String WEB_INF_TOBAGO_CONFIG_XML = "WEB-INF/tobago-config.xml";
    private static final String META_INF_TOBAGO_CONFIG_XML = "META-INF/tobago-config.xml";
    private static final String META_INF_TOBAGO_THEME_XML = "META-INF/tobago-theme.xml";
    private List<TobagoConfigFragment> list = new ArrayList<TobagoConfigFragment>();

    private TobagoConfigBuilder(ServletContext servletContext) throws ServletException, IOException, SAXException {
        this.configFromClasspath();
        this.configFromWebInf(servletContext);
        TobagoConfigImpl tobagoConfig = this.mergeList();
        tobagoConfig.initProjectState(servletContext);
        ResourceManagerFactory.init(servletContext, tobagoConfig);
        tobagoConfig.resolveThemes();
        tobagoConfig.initDefaultValidatorInfo();
        servletContext.setAttribute("org.apache.myfaces.tobago.config.TobagoConfig", (Object)tobagoConfig);
    }

    public static void init(ServletContext servletContext) {
        block2: {
            try {
                TobagoConfigBuilder builder = new TobagoConfigBuilder(servletContext);
            }
            catch (Throwable e) {
                if (!LOG.isErrorEnabled()) break block2;
                String error = "Error while deploy process. Tobago can't be initialized! Application will not run!";
                LOG.error(error, e);
                throw new RuntimeException(error, e);
            }
        }
    }

    private void configFromWebInf(ServletContext servletContext) throws IOException, SAXException {
        URL url = servletContext.getResource("/WEB-INF/tobago-config.xml");
        if (url != null) {
            this.list.add(new TobagoConfigParser().parse(url));
        }
    }

    private TobagoConfigImpl mergeList() {
        LOG.warn("Merge implementation in progress...)");
        TobagoConfigSorter sorter = new TobagoConfigSorter(this.list);
        sorter.sort();
        TobagoConfigImpl result = new TobagoConfigImpl();
        for (TobagoConfigFragment fragment : this.list) {
            String defaultTheme = fragment.getDefaultThemeName();
            if (defaultTheme != null) {
                result.setDefaultThemeName(defaultTheme);
            }
            for (String supported : fragment.getSupportedThemeNames()) {
                result.addSupportedThemeName(supported);
            }
            for (String dir : fragment.getResourceDirs()) {
                result.addResourceDir(dir);
            }
            result.setRenderersConfig(fragment.getRenderersConfig());
            if (fragment.getCreateSessionSecret() != null) {
                result.setCreateSessionSecret(fragment.getCreateSessionSecret());
            }
            if (fragment.getCheckSessionSecret() == null) continue;
            result.setCheckSessionSecret(fragment.getCheckSessionSecret());
        }
        return result;
    }

    private void configFromClasspath() throws ServletException {
        ThemeParser parser = new ThemeParser();
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info("Searching for 'META-INF/tobago-theme.xml' and 'META-INF/tobago-config.xml'");
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            ArrayList urls = new ArrayList();
            CollectionUtils.addAll(urls, classLoader.getResources(META_INF_TOBAGO_CONFIG_XML));
            CollectionUtils.addAll(urls, classLoader.getResources(META_INF_TOBAGO_THEME_XML));
            for (URL themeUrl : urls) {
                TobagoConfigFragment tobagoConfig;
                if (themeUrl.toString().endsWith(META_INF_TOBAGO_CONFIG_XML)) {
                    tobagoConfig = new TobagoConfigParser().parse(themeUrl);
                } else {
                    tobagoConfig = new TobagoConfigFragment();
                    ThemeImpl theme = parser.parse(themeUrl);
                    tobagoConfig.addThemeDefinition(theme);
                }
                tobagoConfig.setUrl(themeUrl);
                String protocol = themeUrl.getProtocol();
                if (!("jar".equals(protocol) || "zip".equals(protocol) || "wsjar".equals(protocol))) {
                    LOG.warn("Unknown protocol '" + themeUrl + "'");
                }
                this.list.add(tobagoConfig);
            }
        }
        catch (Exception e) {
            String msg = "while loading ";
            LOG.error(msg, (Throwable)e);
            throw new ServletException(msg, (Throwable)e);
        }
    }
}

