/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.config;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.myfaces.tobago.internal.config.RendererConfig;
import org.apache.myfaces.tobago.internal.config.RenderersConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderersConfigImpl
implements RenderersConfig,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RenderersConfigImpl.class);
    private Map<String, RendererConfig> rendererMap = new HashMap<String, RendererConfig>();
    private boolean merged = false;

    public boolean isMerged() {
        return this.merged;
    }

    public void setMerged(boolean merged) {
        this.merged = merged;
    }

    @Override
    public Collection<RendererConfig> getRendererConfigs() {
        return this.rendererMap.values();
    }

    public void addRenderer(RendererConfig rendererConfig) {
        String name = rendererConfig.getName();
        if (this.rendererMap.containsKey(name)) {
            this.rendererMap.get(name).merge(rendererConfig);
        } else {
            this.rendererMap.put(name, rendererConfig);
        }
    }

    @Override
    public boolean isMarkupSupported(String rendererName, String markup) {
        RendererConfig rendererConfig;
        if (LOG.isDebugEnabled()) {
            LOG.debug("calling isMarkupSupported('{}', '{}')", (Object)rendererName, (Object)markup);
        }
        if ((rendererConfig = this.rendererMap.get(rendererName)) != null) {
            return rendererConfig.contains(markup);
        }
        LOG.error("Calling isMarkupSupported('{}', '{}'), but no configuration found.", (Object)rendererName, (Object)markup);
        return false;
    }

    public void merge(RenderersConfig renderersConfig, boolean override) {
        Collection<RendererConfig> renderers = renderersConfig.getRendererConfigs();
        for (RendererConfig rendererConfig : renderers) {
            this.addRenderer(rendererConfig);
        }
    }

    public String toString() {
        return this.rendererMap.toString();
    }
}

