/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.myfaces.tobago.compat.FacesUtils;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.component.TreeModelBuilder;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.event.TreeExpansionEvent;
import org.apache.myfaces.tobago.event.TreeExpansionListener;
import org.apache.myfaces.tobago.event.TreeMarkedEvent;
import org.apache.myfaces.tobago.event.TreeMarkedListener;
import org.apache.myfaces.tobago.internal.component.AbstractUITree;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeData;
import org.apache.myfaces.tobago.model.MixedTreeModel;
import org.apache.myfaces.tobago.model.TreePath;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUITreeNode
extends UIOutput
implements SupportsMarkup,
TreeModelBuilder,
Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUITreeNode.class);
    private int depth;
    private boolean folder;
    private TreePath path;
    private List<Boolean> junctions;
    private boolean hasNextSibling;

    @Override
    public void buildTreeModelBegin(FacesContext facesContext, MixedTreeModel model) {
        model.beginBuildNode();
        this.setDepth(this.computeDepth((UIComponent)this));
        this.setFolder(this.computeFolder());
    }

    @Override
    public void buildTreeModelChildren(FacesContext facesContext, MixedTreeModel model) {
        for (Object child : this.getChildren()) {
            if (!(child instanceof TreeModelBuilder)) continue;
            TreeModelBuilder builder = (TreeModelBuilder)child;
            builder.buildTreeModelBegin(facesContext, model);
            builder.buildTreeModelChildren(facesContext, model);
            builder.buildTreeModelEnd(facesContext, model);
        }
    }

    @Override
    public void buildTreeModelEnd(FacesContext facesContext, MixedTreeModel model) {
        model.endBuildNode();
    }

    public void encodeBegin(FacesContext context) throws IOException {
        AbstractUITree tree = ComponentUtils.findAncestor((UIComponent)this, AbstractUITree.class);
        MixedTreeModel mixedModel = tree.getModel();
        mixedModel.onEncodeBegin();
        this.setPath(mixedModel.getPath());
        this.setHasNextSibling(this.computeHasNextSibling());
        this.setJunctions(mixedModel.getJunctions());
        super.encodeBegin(context);
    }

    private int computeDepth(UIComponent component) {
        int depth = 0;
        while (component != null) {
            ++depth;
            if (component instanceof AbstractUITree) {
                return depth;
            }
            if (component instanceof AbstractUITreeData) {
                Object dataTree = ((AbstractUITreeData)component).getValue();
                if (dataTree instanceof DefaultMutableTreeNode) {
                    return ((DefaultMutableTreeNode)dataTree).getDepth();
                }
                LOG.warn("Tree type not supported");
            }
            component = component.getParent();
        }
        throw new RuntimeException("Not inside of a UITree");
    }

    private boolean computeFolder() {
        DefaultMutableTreeNode node = this.getDataNode();
        if (node != null) {
            return !node.isLeaf();
        }
        for (UIComponent child : this.getChildren()) {
            if (!(child instanceof AbstractUITreeNode) && !(child instanceof AbstractUITreeData) || !child.isRendered()) continue;
            return true;
        }
        return false;
    }

    private boolean computeHasNextSibling() {
        DefaultMutableTreeNode node = this.getDataNode();
        if (node != null) {
            if (node.isRoot()) {
                return this.hasSiblingAfter(this.getParent().getParent(), this.getParent());
            }
            return node.getNextSibling() != null;
        }
        return this.hasSiblingAfter(this.getParent(), (UIComponent)this);
    }

    private boolean hasSiblingAfter(UIComponent parent, UIComponent child) {
        boolean found = false;
        for (Object sibling : parent.getChildren()) {
            if (child.equals(sibling)) {
                found = true;
                continue;
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    private DefaultMutableTreeNode getDataNode() {
        for (AbstractUITreeNode component = this; component != null; component = component.getParent()) {
            if (component instanceof AbstractUITreeData) {
                AbstractUITreeData data = (AbstractUITreeData)((Object)component);
                Object currentNode = FacesContext.getCurrentInstance().getExternalContext().getRequestMap().get(data.getVar());
                return (DefaultMutableTreeNode)currentNode;
            }
            if (!(component instanceof AbstractUITree)) continue;
            return null;
        }
        return null;
    }

    public Object getValue() {
        LOG.error("XXXXXXXXXXX should not be called!!!!!!!!!!!!");
        return super.getValue();
    }

    public int getLevel() {
        return this.path.getLength() - 1;
    }

    public String nodeStateId(FacesContext facesContext) {
        String clientId = this.getClientId(facesContext);
        AbstractUITree tree = ComponentUtils.findAncestor((UIComponent)this, AbstractUITree.class);
        String treeId = tree.getClientId(facesContext);
        return clientId.substring(treeId.length() + 1);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof TreeExpansionEvent) {
            FacesUtils.invokeMethodBinding((FacesContext)this.getFacesContext(), (MethodBinding)this.getTreeExpansionListener(), (FacesEvent)event);
            boolean expanded = ((TreeExpansionEvent)event).isNewExpanded();
            if (FacesUtils.hasValueBindingOrValueExpression((UIComponent)this, (String)"expanded")) {
                try {
                    FacesUtils.setValueOfBindingOrExpression((FacesContext)this.getFacesContext(), (Object)expanded, (UIComponent)this, (String)"expanded");
                }
                catch (Exception e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Can't set expanded.", (Throwable)e);
                    }
                }
            } else {
                this.setExpanded(expanded);
            }
        }
        if (event instanceof TreeMarkedEvent) {
            FacesUtils.invokeMethodBinding((FacesContext)this.getFacesContext(), (MethodBinding)this.getTreeMarkedListener(), (FacesEvent)event);
            boolean marked = ((TreeMarkedEvent)event).isNewMarked();
            if (FacesUtils.hasValueBindingOrValueExpression((UIComponent)this, (String)"marked")) {
                try {
                    FacesUtils.setValueOfBindingOrExpression((FacesContext)this.getFacesContext(), (Object)marked, (UIComponent)this, (String)"marked");
                }
                catch (Exception e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Can't set marked.", (Throwable)e);
                    }
                }
            } else {
                this.setMarked(marked);
            }
        }
    }

    public void restoreState(FacesContext context, Object componentState) {
        Object[] values = (Object[])componentState;
        super.restoreState(context, values[0]);
        this.path = (TreePath)values[1];
        this.folder = (Boolean)values[2];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.path, this.folder};
        return values;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public boolean isFolder() {
        return this.folder;
    }

    public void setFolder(boolean folder) {
        this.folder = folder;
    }

    public TreePath getPath() {
        return this.path;
    }

    public void setPath(TreePath path) {
        this.path = path;
    }

    public List<Boolean> getJunctions() {
        return this.junctions;
    }

    public void setJunctions(List<Boolean> junctions) {
        this.junctions = junctions;
    }

    public boolean isHasNextSibling() {
        return this.hasNextSibling;
    }

    public void setHasNextSibling(boolean hasNextSibling) {
        this.hasNextSibling = hasNextSibling;
    }

    public abstract MethodBinding getTreeExpansionListener();

    public abstract void setTreeExpansionListener(MethodBinding var1);

    public void addTreeExpansionListener(TreeExpansionListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public TreeExpansionListener[] getTreeExpansionListeners() {
        return (TreeExpansionListener[])this.getFacesListeners(TreeExpansionListener.class);
    }

    public void removeStateChangeListener(TreeExpansionListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public abstract MethodBinding getTreeMarkedListener();

    public abstract void setTreeMarkedListener(MethodBinding var1);

    public void addTreeMarkedListener(TreeMarkedListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public TreeMarkedListener[] getTreeMarkedListeners() {
        return (TreeMarkedListener[])this.getFacesListeners(TreeMarkedListener.class);
    }

    public void removeStateChangeListener(TreeMarkedListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public abstract boolean isMarked();

    public abstract void setMarked(boolean var1);

    public abstract boolean isExpanded();

    public abstract void setExpanded(boolean var1);

    public abstract boolean isSelected();

    public abstract void setSelected(boolean var1);
}

