/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.ContextCallback;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang.ObjectUtils;
import org.apache.myfaces.tobago.compat.FacesUtils;
import org.apache.myfaces.tobago.component.TreeModelBuilder;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeNode;
import org.apache.myfaces.tobago.model.MixedTreeModel;
import org.apache.myfaces.tobago.model.Node;
import org.apache.myfaces.tobago.model.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUITreeData
extends UIInput
implements NamingContainer,
TreeModelBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUITreeData.class);
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.TreeData";
    private String var;
    private DefaultMutableTreeNode currentNode;
    private TreePath rowIndex;
    private Object marked;
    private Map<TreePath, Object> pathStates = new HashMap<TreePath, Object>();

    public void processDecodes(FacesContext facesContext) {
        this.decodeNodes(facesContext, (DefaultMutableTreeNode)this.getValue(), new TreePath(0));
    }

    private void decodeNodes(FacesContext facesContext, DefaultMutableTreeNode node, TreePath position) {
        this.setRowIndex(facesContext, position);
        LOG.debug("path index (decode) = '" + position + "'");
        AbstractUITreeNode templateComponent = this.getTemplateComponent();
        templateComponent.processDecodes(facesContext);
        this.setRowIndex(facesContext, null);
        if (templateComponent.isMarked()) {
            this.marked = templateComponent.getValue();
        }
        int index = 0;
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode sub = (DefaultMutableTreeNode)e.nextElement();
            this.decodeNodes(facesContext, sub, new TreePath(position, index));
            ++index;
        }
    }

    public void decode(FacesContext facesContext) {
    }

    public void processValidators(FacesContext facesContext) {
        this.validateNodes(facesContext, (DefaultMutableTreeNode)this.getValue(), new TreePath(0));
    }

    private void validateNodes(FacesContext facesContext, DefaultMutableTreeNode node, TreePath position) {
        this.setRowIndex(facesContext, position);
        LOG.debug("path index (validate) = '" + position + "'");
        AbstractUITreeNode templateComponent = this.getTemplateComponent();
        templateComponent.processValidators(facesContext);
        this.setRowIndex(facesContext, null);
        int index = 0;
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode sub = (DefaultMutableTreeNode)e.nextElement();
            this.validateNodes(facesContext, sub, new TreePath(position, index));
            ++index;
        }
    }

    public void processUpdates(FacesContext facesContext) {
        this.updateNodes(facesContext, (DefaultMutableTreeNode)this.getValue(), new TreePath(0));
    }

    private void updateNodes(FacesContext facesContext, DefaultMutableTreeNode node, TreePath position) {
        this.setRowIndex(facesContext, position);
        if (LOG.isDebugEnabled()) {
            LOG.debug("path index (update) = '" + position + "'");
        }
        AbstractUITreeNode templateComponent = this.getTemplateComponent();
        templateComponent.processUpdates(facesContext);
        this.setRowIndex(facesContext, null);
        int index = 0;
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode sub = (DefaultMutableTreeNode)e.nextElement();
            this.updateNodes(facesContext, sub, new TreePath(position, index));
            ++index;
        }
    }

    public TreePath getRowIndex() {
        return this.rowIndex;
    }

    private void setRowIndex(FacesContext facesContext, TreePath rowIndex) {
        if (ObjectUtils.equals((Object)this.rowIndex, (Object)rowIndex)) {
            return;
        }
        AbstractUITreeNode template = this.getTemplateComponent();
        this.pathStates.put(this.rowIndex, this.saveStateDeep(facesContext, (UIComponent)template));
        if (LOG.isDebugEnabled()) {
            LOG.debug("save   " + this.rowIndex + " ex=" + template.isExpanded());
        }
        this.rowIndex = rowIndex;
        if (rowIndex != null) {
            DefaultMutableTreeNode model = (DefaultMutableTreeNode)this.getValue();
            this.currentNode = rowIndex.getNode(model);
            facesContext.getExternalContext().getRequestMap().put(this.var, this.currentNode);
        } else {
            FacesContext.getCurrentInstance().getExternalContext().getRequestMap().remove(this.var);
            this.currentNode = null;
        }
        Object state = this.pathStates.get(this.rowIndex);
        if (state != null) {
            this.restoreStateDeep(facesContext, (UIComponent)template, state);
            if (LOG.isDebugEnabled()) {
                LOG.debug("restore " + this.rowIndex + " ex=" + template.isExpanded());
            }
        }
    }

    private void restoreStateDeep(FacesContext facesContext, UIComponent template, Object stateObject) {
        List state = (List)stateObject;
        int i = 0;
        template.restoreState(facesContext, state.get(i++));
        template.setId(template.getId());
        Iterator facetsAndChildren = template.getFacetsAndChildren();
        while (facetsAndChildren.hasNext()) {
            UIComponent component = (UIComponent)facetsAndChildren.next();
            this.restoreStateDeep(facesContext, component, state.get(i++));
        }
    }

    private Object saveStateDeep(FacesContext facesContext, UIComponent template) {
        ArrayList<Object> state = new ArrayList<Object>();
        state.add(template.saveState(facesContext));
        Iterator facetsAndChildren = template.getFacetsAndChildren();
        while (facetsAndChildren.hasNext()) {
            UIComponent component = (UIComponent)facetsAndChildren.next();
            state.add(this.saveStateDeep(facesContext, component));
        }
        return state;
    }

    public void buildTreeModelBegin(FacesContext facesContext, MixedTreeModel model) {
        Object data = this.getValue();
        if (data instanceof Node) {
            this.buildTreeModelNodes(facesContext, model, (Node)data, new TreePath(0));
        } else if (data instanceof DefaultMutableTreeNode) {
            this.buildTreeModelNodes(facesContext, model, (DefaultMutableTreeNode)data, new TreePath(0));
        }
    }

    public void buildTreeModelChildren(FacesContext facesContext, MixedTreeModel model) {
    }

    public void buildTreeModelEnd(FacesContext facesContext, MixedTreeModel model) {
    }

    public void buildTreeModelNodes(FacesContext facesContext, MixedTreeModel model, Node node, TreePath position) {
        this.setRowIndex(facesContext, position);
        LOG.debug("path index (build) node = '" + position + "'");
        this.getTemplateComponent().buildTreeModelBegin(facesContext, model);
        int index = 0;
        for (Node sub : node.getChildren()) {
            this.buildTreeModelNodes(facesContext, model, sub, new TreePath(position, index));
            ++index;
        }
        this.getTemplateComponent().buildTreeModelEnd(facesContext, model);
        this.setRowIndex(facesContext, null);
    }

    public void buildTreeModelNodes(FacesContext facesContext, MixedTreeModel model, DefaultMutableTreeNode node, TreePath position) {
        this.setRowIndex(facesContext, position);
        LOG.debug("path index (build) dmtn = '" + position + "'");
        this.getTemplateComponent().buildTreeModelBegin(facesContext, model);
        int index = 0;
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode sub = (DefaultMutableTreeNode)e.nextElement();
            this.buildTreeModelNodes(facesContext, model, sub, new TreePath(position, index));
            ++index;
        }
        this.getTemplateComponent().buildTreeModelEnd(facesContext, model);
        this.setRowIndex(facesContext, null);
    }

    public void encodeChildren(FacesContext context) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext) throws IOException {
        this.encodeNodes(facesContext, (DefaultMutableTreeNode)this.getValue(), new TreePath(0));
        super.encodeEnd(facesContext);
    }

    private void encodeNodes(FacesContext facesContext, DefaultMutableTreeNode node, TreePath position) throws IOException {
        this.setRowIndex(facesContext, position);
        LOG.debug("path index (begin)  = '" + position + "'");
        AbstractUITreeNode template = this.getTemplateComponent();
        super.encodeBegin(facesContext);
        template.encodeBegin(facesContext);
        this.setRowIndex(facesContext, null);
        int index = 0;
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode sub = (DefaultMutableTreeNode)e.nextElement();
            this.encodeNodes(facesContext, sub, new TreePath(position, index));
            ++index;
        }
        this.setRowIndex(facesContext, position);
        LOG.debug("path index (end)    = '" + position + "'");
        this.getTemplateComponent().encodeEnd(facesContext);
        this.setRowIndex(facesContext, null);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void updateModel(FacesContext facesContext) {
    }

    public AbstractUITreeNode getTemplateComponent() {
        for (Object child : this.getChildren()) {
            if (!(child instanceof AbstractUITreeNode)) continue;
            return (AbstractUITreeNode)child;
        }
        return null;
    }

    public String getClientId(FacesContext context) {
        String clientId = super.getClientId(context);
        if (this.rowIndex == null) {
            return clientId;
        }
        return clientId + ':' + this.rowIndex;
    }

    public UIComponent findComponent(String searchId) {
        assert (searchId.matches("^(_\\d+)+:.*")) : "The searchId '" + searchId + "' does not start with a tree structure";
        searchId = searchId.substring(searchId.indexOf(58) + 1);
        return super.findComponent(searchId);
    }

    public void queueEvent(FacesEvent event) {
        super.queueEvent((FacesEvent)new FacesEventWrapper(event, this.getRowIndex(), this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof FacesEventWrapper) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            FacesEvent originalEvent = ((FacesEventWrapper)event).getWrappedFacesEvent();
            TreePath eventPathIndex = ((FacesEventWrapper)event).getRowIndex();
            TreePath currentPathIndex = this.getRowIndex();
            this.setRowIndex(facesContext, eventPathIndex);
            try {
                originalEvent.getComponent().broadcast(originalEvent);
            }
            finally {
                this.setRowIndex(facesContext, currentPathIndex);
            }
        } else {
            super.broadcast(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokeOnComponent(FacesContext facesContext, String clientId, ContextCallback callback) throws FacesException {
        TreePath oldRowIndex = this.getRowIndex();
        try {
            String sheetId = this.getClientId(facesContext);
            if (clientId.startsWith(sheetId)) {
                String idRemainder = clientId.substring(sheetId.length());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("idRemainder = '" + idRemainder + "'");
                }
                if (idRemainder.matches("^:(_\\d+)+:.*")) {
                    idRemainder = idRemainder.substring(1);
                    int idx = idRemainder.indexOf(":");
                    try {
                        TreePath rowIndex = new TreePath(idRemainder.substring(0, idx));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("set rowIndex = '" + rowIndex + "'");
                        }
                        this.setRowIndex(facesContext, rowIndex);
                    }
                    catch (NumberFormatException e) {
                        LOG.warn("idRemainder = '" + idRemainder + "'", (Throwable)e);
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("no match for '^:(_\\d+)+:.*'");
                }
            }
            boolean bl = FacesUtils.invokeOnComponent((FacesContext)facesContext, (UIComponent)this, (String)clientId, (ContextCallback)callback);
            return bl;
        }
        finally {
            this.setRowIndex(facesContext, oldRowIndex);
        }
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{super.saveState(context), this.var};
        return state;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.var = (String)values[1];
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public DefaultMutableTreeNode getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(DefaultMutableTreeNode currentNode) {
        this.currentNode = currentNode;
    }

    public Object getMarker() {
        return this.marked;
    }

    private static class FacesEventWrapper
    extends FacesEvent {
        private static final long serialVersionUID = 1L;
        private FacesEvent wrappedFacesEvent;
        private TreePath rowIndex;

        FacesEventWrapper(FacesEvent facesEvent, TreePath rowIndex, AbstractUITreeData redirectComponent) {
            super((UIComponent)redirectComponent);
            this.wrappedFacesEvent = facesEvent;
            this.rowIndex = rowIndex;
        }

        public PhaseId getPhaseId() {
            return this.wrappedFacesEvent.getPhaseId();
        }

        public void setPhaseId(PhaseId phaseId) {
            this.wrappedFacesEvent.setPhaseId(phaseId);
        }

        public void queue() {
            this.wrappedFacesEvent.queue();
        }

        public String toString() {
            return this.wrappedFacesEvent.toString();
        }

        public boolean isAppropriateListener(FacesListener faceslistener) {
            return this.wrappedFacesEvent.isAppropriateListener(faceslistener);
        }

        public void processListener(FacesListener faceslistener) {
            this.wrappedFacesEvent.processListener(faceslistener);
        }

        public FacesEvent getWrappedFacesEvent() {
            return this.wrappedFacesEvent;
        }

        public TreePath getRowIndex() {
            return this.rowIndex;
        }
    }
}

