/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.application;

import java.io.IOException;
import java.util.Locale;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.portlet.PortletUtils;
import org.apache.myfaces.tobago.util.DebugUtils;
import org.apache.myfaces.tobago.util.RequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewHandlerImpl
extends ViewHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ViewHandlerImpl.class);
    private ViewHandler base;

    public ViewHandlerImpl(ViewHandler base) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Hiding RI base implementation: " + base);
        }
        this.base = base;
    }

    public Locale calculateLocale(FacesContext facesContext) {
        return this.base.calculateLocale(facesContext);
    }

    public String calculateRenderKitId(FacesContext facesContext) {
        return this.base.calculateRenderKitId(facesContext);
    }

    public UIViewRoot createView(FacesContext facesContext, String viewId) {
        UIViewRoot viewRoot;
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating new view with viewId:        '{}'", (Object)viewId);
        }
        if (!((viewRoot = this.base.createView(facesContext, viewId)) instanceof org.apache.myfaces.tobago.component.UIViewRoot)) {
            UIViewRoot tobagoViewRoot = (UIViewRoot)facesContext.getApplication().createComponent("javax.faces.ViewRoot");
            if (!(tobagoViewRoot instanceof org.apache.myfaces.tobago.component.UIViewRoot)) {
                LOG.warn("Application creating wrong UIViewRoot, forcing Tobago");
                tobagoViewRoot = new org.apache.myfaces.tobago.component.UIViewRoot();
            }
            tobagoViewRoot.setLocale(viewRoot.getLocale());
            tobagoViewRoot.setViewId(viewId);
            tobagoViewRoot.setRenderKitId(viewRoot.getRenderKitId());
            viewRoot = tobagoViewRoot;
        }
        return viewRoot;
    }

    public String getActionURL(FacesContext facesContext, String viewId) {
        if (PortletUtils.isRenderResponse((FacesContext)facesContext)) {
            return PortletUtils.setViewIdForUrl((FacesContext)facesContext, (String)viewId);
        }
        return this.base.getActionURL(facesContext, viewId);
    }

    public String getResourceURL(FacesContext facesContext, String path) {
        return this.base.getResourceURL(facesContext, path);
    }

    public void renderView(FacesContext facesContext, UIViewRoot viewRoot) throws IOException, FacesException {
        this.base.renderView(facesContext, viewRoot);
        if (LOG.isDebugEnabled()) {
            LOG.debug("VIEW");
            LOG.debug(DebugUtils.toString((UIComponent)facesContext.getViewRoot(), 0));
        }
    }

    public UIViewRoot restoreView(FacesContext facesContext, String viewId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("restore view with viewId:             '{}'", (Object)viewId);
        }
        RequestUtils.ensureEncoding((FacesContext)facesContext);
        UIViewRoot viewRoot = this.base.restoreView(facesContext, viewId);
        return viewRoot;
    }

    public void writeState(FacesContext facesContext) throws IOException {
        this.base.writeState(facesContext);
    }
}

