/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.ajax;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.StateManager;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.tobago.compat.FacesUtils;
import org.apache.myfaces.tobago.internal.ajax.AjaxInternalUtils;
import org.apache.myfaces.tobago.internal.component.AbstractUIPage;
import org.apache.myfaces.tobago.internal.lifecycle.TobagoLifecycle;
import org.apache.myfaces.tobago.internal.util.FacesContextUtils;
import org.apache.myfaces.tobago.internal.util.ResponseUtils;
import org.apache.myfaces.tobago.internal.webapp.JsonResponseWriter;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.util.EncodeAjaxCallback;
import org.apache.myfaces.tobago.util.RequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AjaxResponseRenderer {
    public static final int CODE_SUCCESS = 200;
    @Deprecated
    public static final int CODE_NOT_MODIFIED = 304;
    public static final int CODE_RELOAD_REQUIRED = 309;
    public static final int CODE_ERROR = 500;
    public static final String CONTENT_TYPE = "application/json";
    private static final Logger LOG = LoggerFactory.getLogger(AjaxResponseRenderer.class);
    private EncodeAjaxCallback callback = new EncodeAjaxCallback();

    public void renderResponse(FacesContext facesContext) throws IOException {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = renderFactory.getRenderKit(facesContext, viewRoot.getRenderKitId());
        UIViewRoot incomingViewRoot = (UIViewRoot)facesContext.getExternalContext().getRequestMap().get(TobagoLifecycle.VIEW_ROOT_KEY);
        if (viewRoot != incomingViewRoot) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("requesting full page reload because of navigation to {} from {}", (Object)viewRoot.getViewId(), (Object)incomingViewRoot.getViewId());
            }
            Map sessionMap = facesContext.getExternalContext().getSessionMap();
            sessionMap.put(TobagoLifecycle.VIEW_ROOT_KEY, viewRoot);
            ArrayList<Object[]> messageHolders = new ArrayList<Object[]>();
            Iterator clientIds = facesContext.getClientIdsWithMessages();
            while (clientIds.hasNext()) {
                String clientId = (String)clientIds.next();
                Iterator messages = facesContext.getMessages(clientId);
                while (messages.hasNext()) {
                    Object[] messageHolder = new Object[]{clientId, messages.next()};
                    messageHolders.add(messageHolder);
                }
            }
            if (!messageHolders.isEmpty()) {
                sessionMap.put(TobagoLifecycle.FACES_MESSAGES_KEY, messageHolders);
            }
            this.writeResponse(facesContext, renderKit, true);
        } else {
            this.writeResponse(facesContext, renderKit, false);
        }
    }

    private void renderComponent(FacesContext facesContext, RenderKit renderKit, String clientId, UIComponent component) throws IOException {
        PrintWriter writer = this.getPrintWriter(facesContext);
        JsonResponseWriter jsonWriter = this.getJsonResponseWriter(renderKit, writer);
        facesContext.setResponseWriter((ResponseWriter)jsonWriter);
        if (LOG.isDebugEnabled()) {
            LOG.debug("write ajax response for {}", (Object)component);
        }
        writer.write("{\n    \"ajaxId\": \"");
        writer.write(clientId);
        writer.write("\",\n");
        writer.write("    \"html\": \"");
        FacesUtils.invokeOnComponent((FacesContext)facesContext, (UIComponent)facesContext.getViewRoot(), (String)clientId, (ContextCallback)this.callback);
        writer.write("\",\n");
        writer.write("    \"responseCode\": ");
        writer.write(Integer.toString(200));
        writer.write(",\n");
        writer.write("    \"script\": \"function() { ");
        writer.write(jsonWriter.getJavascript());
        writer.write(" }\"");
        writer.write("\n  }");
    }

    private void saveState(FacesContext facesContext, RenderKit renderKit) throws IOException {
        ResponseWriter stateWriter = renderKit.createResponseWriter((Writer)this.getPrintWriter(facesContext), CONTENT_TYPE, null);
        facesContext.setResponseWriter(stateWriter);
        StateManager stateManager = facesContext.getApplication().getStateManager();
        Object view = stateManager.saveView(facesContext);
        stateManager.writeState(facesContext, view);
    }

    private static void ensureContentTypeHeader(FacesContext facesContext, String charset, String contentType) {
        StringBuilder sb = new StringBuilder(contentType);
        if (charset == null) {
            charset = "UTF-8";
        }
        sb.append("; charset=");
        sb.append(charset);
        ResponseUtils.ensureContentTypeHeader(facesContext, sb.toString());
    }

    private void writeResponse(FacesContext facesContext, RenderKit renderKit, boolean reloadRequired) throws IOException {
        RequestUtils.ensureEncoding((FacesContext)facesContext);
        ResponseUtils.ensureNoCacheHeader(facesContext);
        AbstractUIPage page = ComponentUtils.findPage(facesContext);
        String charset = page != null ? (String)page.getAttributes().get("charset") : "UTF-8";
        AjaxResponseRenderer.ensureContentTypeHeader(facesContext, charset, CONTENT_TYPE);
        PrintWriter writer = this.getPrintWriter(facesContext);
        writer.write("{\n  \"tobagoAjaxResponse\": true,\n");
        writer.write("  \"responseCode\": ");
        writer.write(reloadRequired ? Integer.toString(309) : Integer.toString(200));
        Map<String, UIComponent> ajaxComponents = AjaxInternalUtils.getAjaxComponents(facesContext);
        if (ajaxComponents != null) {
            int i = 0;
            for (Map.Entry<String, UIComponent> entry : ajaxComponents.entrySet()) {
                writer.write(",\n");
                writer.write("  \"ajaxPart_");
                writer.write(Integer.toString(i++));
                writer.write("\": ");
                UIComponent component = entry.getValue();
                FacesContextUtils.setAjaxComponentId(facesContext, entry.getKey());
                this.renderComponent(facesContext, renderKit, entry.getKey(), component);
            }
        }
        if (!reloadRequired) {
            writer.write(",\n");
            writer.write("  \"jsfState\": \"");
            this.saveState(facesContext, renderKit);
            writer.write("\"");
        }
        writer.write("\n}\n");
        writer.flush();
        writer.close();
    }

    private PrintWriter getPrintWriter(FacesContext facesContext) throws IOException {
        ExternalContext externalContext = facesContext.getExternalContext();
        if (externalContext.getResponse() instanceof HttpServletResponse) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)externalContext.getResponse();
            return httpServletResponse.getWriter();
        }
        throw new IOException("No ResponseWriter found for ExternalContext " + externalContext);
    }

    private JsonResponseWriter getJsonResponseWriter(RenderKit renderKit, PrintWriter writer) {
        ResponseWriter newWriter = renderKit.createResponseWriter((Writer)writer, CONTENT_TYPE, null);
        if (newWriter instanceof JsonResponseWriter) {
            return (JsonResponseWriter)newWriter;
        }
        return new JsonResponseWriter((Writer)newWriter, CONTENT_TYPE, newWriter.getCharacterEncoding());
    }
}

