/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.ajax;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.ajax.AjaxUtils;
import org.apache.myfaces.tobago.compat.FacesUtils;
import org.apache.myfaces.tobago.internal.ajax.AjaxRenderer;
import org.apache.myfaces.tobago.internal.component.AbstractUIMessages;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxInternalUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AjaxInternalUtils.class);
    public static final String AJAX_COMPONENTS = AjaxUtils.class.getName() + ".AJAX_COMPONENTS";
    private static final String TOBAGO_MESSAGES_CLIENT_IDS = "tobago.messages.clientIds";
    public static final String TOBAGO_PARTIAL_IDS = "tobago::partialIds";

    public static void checkParamValidity(FacesContext facesContext, UIComponent uiComponent, Class compClass) {
        if (facesContext == null) {
            throw new NullPointerException("facesContext may not be null");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent may not be null");
        }
        if (compClass != null && !compClass.isInstance(uiComponent)) {
            throw new IllegalArgumentException("uiComponent : " + uiComponent.getClass().getName() + " is not instance of " + compClass.getName() + " as it should be");
        }
    }

    public static void encodeAjaxComponent(FacesContext facesContext, UIComponent component) throws IOException {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (!component.isRendered()) {
            return;
        }
        RendererBase renderer = ComponentUtils.getRenderer(facesContext, component);
        if (renderer != null && renderer instanceof AjaxRenderer) {
            ((AjaxRenderer)((Object)renderer)).encodeAjax(facesContext, component);
        }
    }

    public static void setRenderAllComponents(FacesContext facesContext) {
        HashMap<String, UIComponent> ajaxComponents = new HashMap<String, UIComponent>();
        facesContext.getExternalContext().getRequestMap().put(AJAX_COMPONENTS, ajaxComponents);
        UIViewRoot viewRoot = facesContext.getViewRoot();
        UIComponent page = (UIComponent)viewRoot.getChildren().get(0);
        ajaxComponents.put(page.getClientId(facesContext), page);
    }

    public static void storeMessagesClientIds(FacesContext facesContext, AbstractUIMessages messages) {
        List<String> messageClientIds;
        Map attributes = FacesUtils.getFacesContextAttributes((FacesContext)facesContext);
        if (attributes.containsKey(TOBAGO_MESSAGES_CLIENT_IDS)) {
            messageClientIds = (List)attributes.get(TOBAGO_MESSAGES_CLIENT_IDS);
        } else {
            messageClientIds = new ArrayList();
            attributes.put(TOBAGO_MESSAGES_CLIENT_IDS, messageClientIds);
        }
        messageClientIds.add(messages.getClientId(facesContext));
    }

    public static List<String> getMessagesClientIds(FacesContext facesContext) {
        return (List)FacesUtils.getFacesContextAttributes((FacesContext)facesContext).get(TOBAGO_MESSAGES_CLIENT_IDS);
    }

    public static List<String> getMessagesComponentIds(FacesContext facesContext) {
        Map parameterMap = facesContext.getExternalContext().getRequestParameterMap();
        UIComponent component = (UIComponent)facesContext.getViewRoot().getChildren().get(0);
        String clientId = component.getClientId(facesContext);
        String ids = (String)parameterMap.get(clientId + "::" + "messagesClientIds");
        ArrayList<String> list = new ArrayList<String>();
        if (ids != null) {
            StringTokenizer tokenizer = new StringTokenizer(ids, ",");
            while (tokenizer.hasMoreTokens()) {
                String id = tokenizer.nextToken();
                list.add(id);
            }
        }
        return list;
    }

    public static Map<String, UIComponent> parseAndStoreComponents(FacesContext facesContext) {
        Map parameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String ajaxComponentIds = (String)parameterMap.get(TOBAGO_PARTIAL_IDS);
        if (ajaxComponentIds != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ajaxComponentIds = \"" + ajaxComponentIds + "\"");
            }
            StringTokenizer tokenizer = new StringTokenizer(ajaxComponentIds, ",");
            HashMap<String, UIComponent> ajaxComponents = new HashMap<String, UIComponent>(tokenizer.countTokens());
            facesContext.getExternalContext().getRequestMap().put(AJAX_COMPONENTS, ajaxComponents);
            UIViewRoot viewRoot = facesContext.getViewRoot();
            while (tokenizer.hasMoreTokens()) {
                String ajaxId = tokenizer.nextToken();
                UIComponent ajaxComponent = viewRoot.findComponent(ajaxId);
                if (ajaxComponent == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ajaxComponent for \"" + ajaxId + "\" = \"" + ajaxComponent + "\"");
                }
                ajaxComponents.put(ajaxId, ajaxComponent);
            }
            return ajaxComponents;
        }
        return null;
    }

    public static Map<String, UIComponent> getAjaxComponents(FacesContext facesContext) {
        return (Map)facesContext.getExternalContext().getRequestMap().get(AJAX_COMPONENTS);
    }

    public static void addAjaxComponent(FacesContext facesContext, UIComponent component) {
        Map ajaxComponents = (Map)facesContext.getExternalContext().getRequestMap().get(AJAX_COMPONENTS);
        if (ajaxComponents != null && !AjaxInternalUtils.alreadyContained(component, ajaxComponents)) {
            ajaxComponents.put(component.getClientId(facesContext), component);
        }
    }

    public static String encodeJavaScriptString(String value) {
        String result = StringUtils.replace((String)value, (String)"\\", (String)"\\\\");
        result = StringUtils.replace((String)result, (String)"\n", (String)"\\n");
        result = StringUtils.replace((String)result, (String)"\r", (String)"\\r");
        return StringUtils.replace((String)result, (String)"\"", (String)"\\\"");
    }

    public static boolean alreadyContained(UIComponent component, Map<String, UIComponent> ajaxComponents) {
        for (UIComponent uiComponent : ajaxComponents.values()) {
            for (UIComponent parent = component; parent != null; parent = parent.getParent()) {
                if (component != uiComponent) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean addNextPossibleAjaxComponent(FacesContext context, String componentClientId) {
        UIComponent component = ComponentUtils.findComponent((UIComponent)context.getViewRoot(), componentClientId);
        if ((component = component.getParent()) instanceof UIPanel) {
            AjaxInternalUtils.addAjaxComponent(context, component);
            return true;
        }
        LOG.error("Ignore adding ajax component (no instance of UIPanel) id: " + componentClientId + " component: " + component);
        return false;
    }

    public static void ensureDecoded(FacesContext facesContext, String clientId) {
        AjaxInternalUtils.ensureDecoded(facesContext, facesContext.getViewRoot().findComponent(clientId));
    }

    public static void ensureDecoded(FacesContext facesContext, UIComponent component) {
        if (component == null) {
            LOG.warn("Ignore AjaxComponent: null");
            return;
        }
        Map<String, UIComponent> ajaxComponents = AjaxInternalUtils.getAjaxComponents(facesContext);
        if (ajaxComponents != null && !AjaxInternalUtils.alreadyContained(component, ajaxComponents)) {
            component.processDecodes(facesContext);
        }
    }
}

