/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.context;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.context.ResourceUtils;
import org.apache.myfaces.tobago.internal.context.ResourceManagerFactory;
import org.apache.myfaces.tobago.layout.Measure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceManagerUtils {
    private ResourceManagerUtils() {
    }

    public static String getProperty(FacesContext facesContext, String bundle, String key) {
        return ResourceManagerFactory.getResourceManager(facesContext).getProperty(facesContext, bundle, key);
    }

    public static String getPropertyNotNull(FacesContext facesContext, String bundle, String key) {
        String result = ResourceManagerFactory.getResourceManager(facesContext).getProperty(facesContext, bundle, key);
        if (result == null) {
            return "???" + key + "???";
        }
        return result;
    }

    public static String getImageWithPath(FacesContext facesContext, String name) {
        return facesContext.getExternalContext().getRequestContextPath() + ResourceManagerFactory.getResourceManager(facesContext).getImage(facesContext, name);
    }

    public static String getImageWithPath(FacesContext facesContext, String name, boolean ignoreMissing) {
        String image = ResourceManagerFactory.getResourceManager(facesContext).getImage(facesContext, name, ignoreMissing);
        if (image == null) {
            return null;
        }
        return facesContext.getExternalContext().getRequestContextPath() + image;
    }

    public static List<String> getStyles(FacesContext facesContext, String name) {
        String contextPath = facesContext.getExternalContext().getRequestContextPath();
        String[] styles = ResourceManagerFactory.getResourceManager(facesContext).getStyles(facesContext, name);
        return ResourceManagerUtils.addContextPath(styles, contextPath);
    }

    private static List<String> addContextPath(String[] strings, String contextPath) {
        ArrayList<String> withContext = new ArrayList<String>(strings.length);
        for (String string : strings) {
            withContext.add(contextPath + string);
        }
        return withContext;
    }

    public static List<String> getScripts(FacesContext facesContext, String name) {
        String contextPath = facesContext.getExternalContext().getRequestContextPath();
        String[] scripts = ResourceManagerFactory.getResourceManager(facesContext).getScripts(facesContext, name);
        return ResourceManagerUtils.addContextPath(scripts, contextPath);
    }

    public static String getScriptsAsJSArray(FacesContext facesContext, String[] names) {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (String name : names) {
            fileNames.addAll(ResourceManagerUtils.getScripts(facesContext, name));
        }
        return ResourceManagerUtils.toJSArray(fileNames);
    }

    public static String getStylesAsJSArray(FacesContext facesContext, String[] names) {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (String name : names) {
            fileNames.addAll(ResourceManagerUtils.getStyles(facesContext, name));
        }
        return ResourceManagerUtils.toJSArray(fileNames);
    }

    public static String toJSArray(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String name : list) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append('\'');
            sb.append(name);
            sb.append('\'');
        }
        return "[" + sb.toString() + "]";
    }

    public static String getDisabledImageWithPath(FacesContext facesContext, String image) {
        String filename = ResourceUtils.addPostfixToFilename(image, "Disabled");
        return ResourceManagerUtils.getImageWithPath(facesContext, filename, true);
    }

    public static String getBlankPage(FacesContext facesContext) {
        return facesContext.getExternalContext().getRequestContextPath() + "/org/apache/myfaces/tobago/renderkit/html/standard/blank.html";
    }

    public static String getPageWithoutContextPath(FacesContext facesContext, String name) {
        return ResourceManagerFactory.getResourceManager(facesContext).getImage(facesContext, name);
    }

    public static Measure getThemeMeasure(FacesContext facesContext, Configurable configurable, String name) {
        return ResourceManagerFactory.getResourceManager(facesContext).getThemeMeasure(facesContext, configurable.getRendererType(), configurable.getCurrentMarkup(), name);
    }

    public static boolean isAbsoluteResource(String value) {
        if (value == null) {
            return true;
        }
        String upper = value.toUpperCase(Locale.ENGLISH);
        return upper.startsWith("/") || upper.startsWith("HTTP:") || upper.startsWith("HTTPS:") || upper.startsWith("FTP:");
    }
}

