/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib.extension;

import javax.el.ValueExpression;
import javax.faces.webapp.FacetTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import org.apache.myfaces.tobago.internal.layout.LayoutUtils;
import org.apache.myfaces.tobago.internal.taglib.GridLayoutTag;
import org.apache.myfaces.tobago.internal.taglib.LabelTag;
import org.apache.myfaces.tobago.internal.taglib.extension.ExtensionPanelTag;
import org.apache.myfaces.tobago.internal.taglib.extension.TobagoExtensionBodyTagSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelExtensionTag
extends TobagoExtensionBodyTagSupport {
    private static final Logger LOG = LoggerFactory.getLogger(LabelExtensionTag.class);
    public static final String DEFAULT_COLUMNS = "auto;*";
    private ValueExpression value;
    private ValueExpression tip;
    private ValueExpression rendered;
    private ValueExpression columns;
    private String rows = "auto";
    private ValueExpression labelWidth;
    private ValueExpression markup;
    private ExtensionPanelTag panelTag;

    public int doStartTag() throws JspException {
        this.panelTag = new ExtensionPanelTag();
        this.panelTag.setPageContext(this.pageContext);
        this.panelTag.setParent(this.getParent());
        if (this.rendered != null) {
            this.panelTag.setRendered(this.rendered);
        }
        if (this.tip != null) {
            this.panelTag.setTip(this.tip);
        }
        if (this.id != null) {
            this.panelTag.setId(this.id);
        }
        this.panelTag.setJspId(this.jspId + "tx" + this.idSuffix++);
        this.panelTag.doStartTag();
        FacetTag facetTag = new FacetTag();
        facetTag.setPageContext(this.pageContext);
        facetTag.setName("layout");
        facetTag.setParent((Tag)this.panelTag);
        facetTag.doStartTag();
        if (this.columns == null) {
            if (this.labelWidth != null) {
                this.setColumns(this.createStringValueExpression(this.labelWidth.getExpressionString() + ";*"));
            } else {
                this.setColumns(this.createStringValueExpression(DEFAULT_COLUMNS));
            }
        }
        GridLayoutTag gridLayoutTag = new GridLayoutTag();
        gridLayoutTag.setPageContext(this.pageContext);
        gridLayoutTag.setColumns(this.columns);
        ValueExpression ve = this.createStringValueExpression(this.rows);
        gridLayoutTag.setRows(ve);
        gridLayoutTag.setParent((Tag)facetTag);
        gridLayoutTag.setJspId(this.jspId + "tx" + this.idSuffix++);
        gridLayoutTag.doStartTag();
        gridLayoutTag.doEndTag();
        facetTag.doEndTag();
        LabelTag labelTag = new LabelTag();
        labelTag.setPageContext(this.pageContext);
        if (this.value != null) {
            labelTag.setValue(this.value);
        }
        if (this.markup != null) {
            labelTag.setMarkup(this.markup);
        }
        labelTag.setFor("@auto");
        labelTag.setParent((Tag)this.panelTag);
        labelTag.setJspId(this.jspId + "tx" + this.idSuffix++);
        labelTag.doStartTag();
        labelTag.doEndTag();
        return super.doStartTag();
    }

    public int doEndTag() throws JspException {
        this.panelTag.doEndTag();
        return super.doEndTag();
    }

    public void release() {
        super.release();
        this.value = null;
        this.tip = null;
        this.rendered = null;
        this.columns = null;
        this.rows = "auto";
        this.panelTag = null;
        this.labelWidth = null;
        this.markup = null;
    }

    public void setValue(ValueExpression value) {
        this.value = value;
    }

    public void setTip(ValueExpression tip) {
        this.tip = tip;
    }

    public void setRendered(ValueExpression rendered) {
        this.rendered = rendered;
    }

    void setColumns(ValueExpression columns) {
        if (columns.isLiteralText() && !LayoutUtils.checkTokens((String)columns.getExpressionString())) {
            LOG.warn("Illegal value for columns = \"" + columns.getExpressionString() + "\" replacing with default: \"" + DEFAULT_COLUMNS + "\"");
            this.columns = this.createStringValueExpression(DEFAULT_COLUMNS);
        } else {
            this.columns = columns;
        }
    }

    void setRows(String rows) {
        this.rows = rows;
    }

    public void setLabelWidth(ValueExpression labelWidth) {
        this.labelWidth = labelWidth;
    }

    public void setMarkup(ValueExpression markup) {
        this.markup = markup;
    }
}

