// ---------- Attention: Generated code, please do not modify! -----------  

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.internal.taglib;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.component.UIWizard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** 
 * JSP Tag class, generated from template {@code tag1.2.stg} with class 
 * {@link org.apache.myfaces.tobago.internal.taglib.component.WizardTagDeclaration}.
 */
public final class WizardTag extends TobagoELTag {
  private static final Logger LOG = LoggerFactory.getLogger(WizardTag.class);
  private javax.el.ValueExpression  markup;
  private String var;
  private javax.el.ValueExpression  title;
  private String outcome;
  private javax.el.ValueExpression  allowJumpForward;
  private javax.el.ValueExpression  controller;

  @Override
  public String getComponentType() {
    return UIWizard.COMPONENT_TYPE;
  }
  @Override
  public String getRendererType() {
    return "Wizard";
  }

  @Override
  protected void setProperties(final UIComponent uiComponent) {
    super.setProperties(uiComponent);
    final UIWizard component = (UIWizard) uiComponent;
    final FacesContext context = FacesContext.getCurrentInstance();
    final Application application = context.getApplication();
    if (markup != null) {
      if (!markup.isLiteralText()) {
        component.setValueExpression("markup", markup);
      } else {
        component.setMarkup(org.apache.myfaces.tobago.context.Markup.valueOf(markup.getExpressionString()));
      }
    }
    if (var != null) {
      component.setVar(var);
    }

    if (title != null) {
      component.setValueExpression("title", title);
    }

    if (outcome != null) {
      component.setOutcome(outcome);
    }

    if (allowJumpForward != null) {
      if (!allowJumpForward.isLiteralText()) {
        component.setValueExpression("allowJumpForward", allowJumpForward);
      } else {
        component.setAllowJumpForward(Boolean.parseBoolean(allowJumpForward.getExpressionString()));
      }
    }
    if (controller != null) {
      if (!controller.isLiteralText()) {
        component.setValueExpression("controller", controller);
      /*} else {
        component.setController(controller.getExpressionString());*/
      }
    }
  }

  public javax.el.ValueExpression getMarkup() {
    return markup;
  }

  public void setMarkup(final javax.el.ValueExpression markup) {
    this.markup = markup;
  }

  public String getVar() {
    return var;
  }

  public void setVar(final String var) {
    this.var = var;
  }

  public javax.el.ValueExpression getTitle() {
    return title;
  }

  public void setTitle(final javax.el.ValueExpression title) {
    this.title = title;
  }

  public String getOutcome() {
    return outcome;
  }

  public void setOutcome(final String outcome) {
    this.outcome = outcome;
  }

  public javax.el.ValueExpression getAllowJumpForward() {
    return allowJumpForward;
  }

  public void setAllowJumpForward(final javax.el.ValueExpression allowJumpForward) {
    this.allowJumpForward = allowJumpForward;
  }

  public javax.el.ValueExpression getController() {
    return controller;
  }

  public void setController(final javax.el.ValueExpression controller) {
    this.controller = controller;
  }



  @Override
  public void release() {
    super.release();
    markup = null;
    var = null;
    title = null;
    outcome = null;
    allowJumpForward = null;
    controller = null;
  }
}