// ---------- Attention: Generated code, please do not modify! -----------  

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.internal.taglib;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.component.UICell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** 
 * JSP Tag class, generated from template {@code tag1.2.stg} with class 
 * {@link org.apache.myfaces.tobago.internal.taglib.component.CellTagDeclaration}.
 */
public final class CellTag extends TobagoELTag {
  private static final Logger LOG = LoggerFactory.getLogger(CellTag.class);
  private javax.el.ValueExpression  markup;
  private javax.el.ValueExpression  scrollbars;
  private javax.el.ValueExpression  spanX;
  private javax.el.ValueExpression  spanY;

  @Override
  public String getComponentType() {
    return UICell.COMPONENT_TYPE;
  }
  @Override
  public String getRendererType() {
    return "Cell";
  }

  @Override
  protected void setProperties(final UIComponent uiComponent) {
    super.setProperties(uiComponent);
    final UICell component = (UICell) uiComponent;
    final FacesContext context = FacesContext.getCurrentInstance();
    final Application application = context.getApplication();
    if (markup != null) {
      if (!markup.isLiteralText()) {
        component.setValueExpression("markup", markup);
      } else {
        component.setMarkup(org.apache.myfaces.tobago.context.Markup.valueOf(markup.getExpressionString()));
      }
    }
    if (scrollbars != null) {
      component.setValueExpression("scrollbars", scrollbars);
    }

    if (spanX != null) {
      if (!spanX.isLiteralText()) {
        component.setValueExpression("spanX", spanX);
      } else {
        component.setSpanX(Integer.parseInt(spanX.getExpressionString()));
      }
    }
    if (spanY != null) {
      if (!spanY.isLiteralText()) {
        component.setValueExpression("spanY", spanY);
      } else {
        component.setSpanY(Integer.parseInt(spanY.getExpressionString()));
      }
    }
  }

  public javax.el.ValueExpression getMarkup() {
    return markup;
  }

  public void setMarkup(final javax.el.ValueExpression markup) {
    this.markup = markup;
  }

  public javax.el.ValueExpression getScrollbars() {
    return scrollbars;
  }

  public void setScrollbars(final javax.el.ValueExpression scrollbars) {
    this.scrollbars = scrollbars;
  }

  public javax.el.ValueExpression getSpanX() {
    return spanX;
  }

  public void setSpanX(final javax.el.ValueExpression spanX) {
    this.spanX = spanX;
  }

  public javax.el.ValueExpression getSpanY() {
    return spanY;
  }

  public void setSpanY(final javax.el.ValueExpression spanY) {
    this.spanY = spanY;
  }



  @Override
  public void release() {
    super.release();
    markup = null;
    scrollbars = null;
    spanX = null;
    spanY = null;
  }
}