/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.util;

import java.io.UnsupportedEncodingException;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.myfaces.tobago.portlet.PortletUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RequestUtils.class);

    public static void ensureEncoding(FacesContext facesContext) {
        Object requestObject = facesContext.getExternalContext().getRequest();
        try {
            if (requestObject instanceof HttpServletRequest) {
                HttpServletRequest request = (HttpServletRequest)requestObject;
                if (request.getCharacterEncoding() == null) {
                    request.setCharacterEncoding("UTF-8");
                }
            } else if (PortletUtils.isPortletRequest(facesContext)) {
                PortletUtils.ensureEncoding(facesContext);
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("" + e, (Throwable)e);
        }
    }
}

