/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.event;

import javax.el.ValueExpression;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.event.AbstractResetInputActionListener;
import org.apache.myfaces.tobago.internal.util.FindComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueExpressionResetInputActionListener
extends AbstractResetInputActionListener
implements StateHolder {
    private static final Logger LOG = LoggerFactory.getLogger(ValueExpressionResetInputActionListener.class);
    private ValueExpression clientIdsExpression;

    public ValueExpressionResetInputActionListener(Object binding) {
        this.clientIdsExpression = (ValueExpression)binding;
    }

    public void processAction(ActionEvent event) {
        String[] clientIds;
        Object obj = this.clientIdsExpression.getValue(FacesContext.getCurrentInstance().getELContext());
        if (obj instanceof String[]) {
            clientIds = (String[])obj;
        } else if (obj instanceof String) {
            clientIds = StringUtils.split((String)((String)obj), (String)", ");
        } else {
            LOG.error("Ignore unknown value of " + obj + " for reset.");
            return;
        }
        for (String clientId : clientIds) {
            UIComponent component = FindComponentUtils.findComponent(event.getComponent(), clientId);
            if (component == null) continue;
            this.resetChildren(component);
        }
    }

    public boolean isTransient() {
        return false;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.clientIdsExpression = (ValueExpression)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)values[0]);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.clientIdsExpression)};
        return values;
    }

    public void setTransient(boolean newTransientValue) {
    }
}

