/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.event;

import javax.el.ValueExpression;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.apache.myfaces.tobago.event.AbstractPopupActionListener;
import org.apache.myfaces.tobago.internal.util.FindComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueExpressionPopupActionListener
extends AbstractPopupActionListener
implements StateHolder {
    private static final Logger LOG = LoggerFactory.getLogger(ValueExpressionPopupActionListener.class);
    private ValueExpression popupIdExpression;

    public ValueExpressionPopupActionListener(Object expression) {
        this.popupIdExpression = (ValueExpression)expression;
    }

    protected UIComponent getPopup(ActionEvent actionEvent) {
        String id = (String)this.popupIdExpression.getValue(FacesContext.getCurrentInstance().getELContext());
        UIComponent popup = FindComponentUtils.findComponent(actionEvent.getComponent(), id);
        if (popup == null) {
            LOG.error("Found no popup for \"" + this.popupIdExpression.getExpressionString() + "\" := \"" + id + "\"! Search base componentId : " + actionEvent.getComponent().getClientId(FacesContext.getCurrentInstance()));
        }
        return popup;
    }

    public boolean isTransient() {
        return false;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.popupIdExpression = (ValueExpression)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)values[0]);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.popupIdExpression)};
        return values;
    }

    public void setTransient(boolean newTransientValue) {
    }
}

