/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.component.SupportsRenderedPartially;
import org.apache.myfaces.tobago.component.UICommand;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.component.UISheet;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.internal.component.AbstractUIMenu;
import org.apache.myfaces.tobago.internal.util.Deprecation;
import org.apache.myfaces.tobago.internal.util.FacesContextUtils;
import org.apache.myfaces.tobago.internal.webapp.TobagoResponseWriterWrapper;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.html.StyleClasses;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.util.FacetUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HtmlRendererUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HtmlRendererUtils.class);
    private static final String ERROR_FOCUS_KEY = HtmlRendererUtils.class.getName() + ".ErrorFocusId";

    private HtmlRendererUtils() {
    }

    private static boolean renderErrorFocusId(FacesContext facesContext, UIInput input) throws IOException {
        if (ComponentUtils.isError((UIInput)input)) {
            if (!FacesContext.getCurrentInstance().getExternalContext().getRequestMap().containsKey(ERROR_FOCUS_KEY)) {
                FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put(ERROR_FOCUS_KEY, Boolean.TRUE);
                TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
                String id = input.getClientId(facesContext);
                writer.writeJavascript("Tobago.errorFocusId = '" + id + "';");
                return true;
            }
            return true;
        }
        return FacesContext.getCurrentInstance().getExternalContext().getRequestMap().containsKey(ERROR_FOCUS_KEY);
    }

    public static void renderFocusId(FacesContext facesContext, UIComponent component) throws IOException {
        if (component instanceof UIInput) {
            HtmlRendererUtils.renderFocusId(facesContext, (UIInput)component);
        }
    }

    public static void renderFocusId(FacesContext facesContext, UIInput component) throws IOException {
        if (HtmlRendererUtils.renderErrorFocusId(facesContext, component)) {
            return;
        }
        if (ComponentUtils.getBooleanAttribute((UIComponent)component, (String)"focus")) {
            UIPage page = (UIPage)ComponentUtils.findPage((FacesContext)facesContext, (UIComponent)component);
            String id = component.getClientId(facesContext);
            if (!StringUtils.isBlank((String)page.getFocusId()) && !page.getFocusId().equals(id)) {
                LOG.warn("page focusId = \"" + page.getFocusId() + "\" ignoring new value \"" + id + "\"");
            } else {
                TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
                writer.writeJavascript("Tobago.focusId = '" + id + "';");
            }
        }
    }

    public static void createCssClass(FacesContext facesContext, UIComponent component) {
        String rendererName = HtmlRendererUtils.getRendererName(facesContext, component);
        if (rendererName != null) {
            StyleClasses classes = StyleClasses.ensureStyleClasses((UIComponent)component);
            classes.updateClassAttributeAndMarkup(component, rendererName);
        }
    }

    public static String getRendererName(FacesContext facesContext, UIComponent component) {
        String rendererType = component.getRendererType();
        return rendererType.substring(0, 1).toLowerCase(Locale.ENGLISH) + rendererType.substring(1);
    }

    public static void writeLabelWithAccessKey(TobagoResponseWriter writer, LabelWithAccessKey label) throws IOException {
        int pos = label.getPos();
        String text = label.getText();
        if (pos == -1) {
            writer.writeText(text);
        } else {
            writer.writeText(text.substring(0, pos));
            writer.startElement("u", null);
            writer.writeText(Character.toString(text.charAt(pos)));
            writer.endElement("u");
            writer.writeText(text.substring(pos + 1));
        }
    }

    public static void setDefaultTransition(FacesContext facesContext, boolean transition) throws IOException {
        HtmlRendererUtils.writeScriptLoader(facesContext, null, new String[]{"Tobago.transition = " + transition + ";"});
    }

    public static void addClickAcceleratorKey(FacesContext facesContext, String clientId, char key) throws IOException {
        HtmlRendererUtils.addClickAcceleratorKey(facesContext, clientId, key, null);
    }

    public static void addClickAcceleratorKey(FacesContext facesContext, String clientId, char key, String modifier) throws IOException {
        String str = HtmlRendererUtils.createOnclickAcceleratorKeyJsStatement(clientId, key, modifier);
        HtmlRendererUtils.writeScriptLoader(facesContext, null, new String[]{str});
    }

    public static void addAcceleratorKey(FacesContext facesContext, String func, char key) throws IOException {
        HtmlRendererUtils.addAcceleratorKey(facesContext, func, key, null);
    }

    public static void addAcceleratorKey(FacesContext facesContext, String func, char key, String modifier) throws IOException {
        String str = HtmlRendererUtils.createAcceleratorKeyJsStatement(func, key, modifier);
        HtmlRendererUtils.writeScriptLoader(facesContext, null, new String[]{str});
    }

    public static String createOnclickAcceleratorKeyJsStatement(String clientId, char key, String modifier) {
        String func = "Tobago.clickOnElement('" + clientId + "');";
        return HtmlRendererUtils.createAcceleratorKeyJsStatement(func, key, modifier);
    }

    public static String createAcceleratorKeyJsStatement(String func, char key, String modifier) {
        StringBuilder buffer = new StringBuilder("new Tobago.AcceleratorKey(function() {");
        buffer.append(func);
        if (!func.endsWith(";")) {
            buffer.append(';');
        }
        buffer.append("}, \"");
        buffer.append(key);
        if (modifier != null) {
            buffer.append("\", \"");
            buffer.append(modifier);
        }
        buffer.append("\");");
        return buffer.toString();
    }

    @Deprecated
    public static void removeStyleAttribute(UIComponent component, String name) {
        Deprecation.LOG.error("HtmlRendererUtils.removeStyleAttribute() no longer supported. Use setter.");
    }

    @Deprecated
    public static void createHeaderAndBodyStyles(FacesContext facesContext, UIComponent component) {
        Deprecation.LOG.error("HtmlRendererUtils.createHeaderAndBodyStyles() no longer supported");
    }

    @Deprecated
    public static void createHeaderAndBodyStyles(FacesContext facesContext, UIComponent component, boolean width) {
        Deprecation.LOG.error("HtmlRendererUtils.createHeaderAndBodyStyles() no longer supported");
    }

    public static String createSrc(String src, String ext) {
        int dot = src.lastIndexOf(46);
        if (dot == -1) {
            LOG.warn("Image src without extension: '" + src + "'");
            return src;
        }
        return src.substring(0, dot) + ext + src.substring(dot);
    }

    public static TobagoResponseWriter getTobagoResponseWriter(FacesContext facesContext) {
        ResponseWriter writer = facesContext.getResponseWriter();
        if (writer instanceof TobagoResponseWriter) {
            return (TobagoResponseWriter)writer;
        }
        return new TobagoResponseWriterWrapper(writer);
    }

    public static void writeScriptLoader(FacesContext facesContext, String script) throws IOException {
        HtmlRendererUtils.writeScriptLoader(facesContext, new String[]{script}, null);
    }

    public static void writeScriptLoader(FacesContext facesContext, String[] scripts, String[] afterLoadCmds) throws IOException {
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        String allScripts = "[]";
        if (scripts != null) {
            allScripts = ResourceManagerUtils.getScriptsAsJSArray((FacesContext)facesContext, (String[])scripts);
        }
        boolean ajax = FacesContextUtils.isAjax((FacesContext)facesContext);
        writer.startJavascript();
        writer.write("new Tobago.ScriptLoader(");
        if (!ajax) {
            writer.write("\n    ");
        }
        writer.write(allScripts);
        if (afterLoadCmds != null && afterLoadCmds.length > 0) {
            writer.write(", ");
            if (!ajax) {
                writer.write("\n");
            }
            boolean first = true;
            for (String afterLoadCmd : afterLoadCmds) {
                String[] splittedStrings;
                for (String splitted : splittedStrings = StringUtils.split((String)afterLoadCmd, (char)'\n')) {
                    writer.write(first ? "          " : "        + ");
                    writer.write("\"");
                    String cmd = StringUtils.replace((String)splitted, (String)"\\", (String)"\\\\");
                    cmd = StringUtils.replace((String)cmd, (String)"\"", (String)"\\\"");
                    writer.write(cmd);
                    writer.write("\"");
                    if (!ajax) {
                        writer.write("\n");
                    }
                    first = false;
                }
            }
        }
        writer.write(");");
        writer.endJavascript();
    }

    public static void writeStyleLoader(FacesContext facesContext, String[] styles) throws IOException {
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        writer.startJavascript();
        writer.write("Tobago.ensureStyleFiles(");
        writer.write(ResourceManagerUtils.getStylesAsJSArray((FacesContext)facesContext, (String[])styles));
        writer.write(");");
        writer.endJavascript();
    }

    public static String getTitleFromTipAndMessages(FacesContext facesContext, UIComponent component) {
        String messages = ComponentUtils.getFacesMessageAsString((FacesContext)facesContext, (UIComponent)component);
        return HtmlRendererUtils.addTip(messages, component.getAttributes().get("tip"));
    }

    public static String addTip(String title, Object tip) {
        if (tip != null) {
            title = title != null && title.length() > 0 ? title + " :: " : "";
            title = title + tip;
        }
        return title;
    }

    public static void renderSelectItems(UIInput component, List<SelectItem> items, Object[] values, TobagoResponseWriter writer, FacesContext facesContext) throws IOException {
        HtmlRendererUtils.renderSelectItems(component, items, values, null, writer, facesContext);
    }

    public static void renderSelectItems(UIInput component, List<SelectItem> items, Object[] values, Boolean onlySelected, TobagoResponseWriter writer, FacesContext facesContext) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("value = '" + Arrays.toString(values) + "'");
        }
        for (SelectItem item : items) {
            Markup markup;
            String image;
            if (item instanceof SelectItemGroup) {
                writer.startElement("optgroup", null);
                writer.writeAttribute("label", item.getLabel(), true);
                if (item.isDisabled()) {
                    writer.writeAttribute("disabled", true);
                }
                SelectItem[] selectItems = ((SelectItemGroup)item).getSelectItems();
                HtmlRendererUtils.renderSelectItems(component, Arrays.asList(selectItems), values, onlySelected, writer, facesContext);
                writer.endElement("optgroup");
                continue;
            }
            Object itemValue = item.getValue();
            if (itemValue instanceof String && values != null && values.length > 0 && !(values[0] instanceof String)) {
                itemValue = ComponentUtils.getConvertedValue((FacesContext)facesContext, (UIComponent)component, (String)((String)itemValue));
            }
            boolean contains = RenderUtils.contains(values, itemValue);
            if (onlySelected != null && (onlySelected != false ? !contains : contains)) continue;
            writer.startElement("option", null);
            String formattedValue = RenderUtils.getFormattedValue(facesContext, (UIComponent)component, itemValue);
            writer.writeAttribute("value", formattedValue, true);
            if (item instanceof org.apache.myfaces.tobago.model.SelectItem && (image = ((org.apache.myfaces.tobago.model.SelectItem)item).getImage()) != null) {
                String imagePath = ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)image);
                writer.writeStyleAttribute("background-image: url('" + imagePath + "')");
            }
            Markup markup2 = markup = item instanceof SupportsMarkup ? ((SupportsMarkup)item).getMarkup() : Markup.NULL;
            if (onlySelected == null && contains) {
                writer.writeAttribute("selected", true);
                markup = Markup.SELECTED.add(markup);
            }
            if (item.isDisabled()) {
                writer.writeAttribute("disabled", true);
                markup = Markup.DISABLED.add(markup);
            }
            writer.writeClassAttribute(Classes.create((UIComponent)component, (String)"option", (Markup)markup));
            writer.writeText(item.getLabel());
            writer.endElement("option");
        }
    }

    public static String getComponentIds(FacesContext context, UIComponent component, String[] componentId) {
        StringBuilder sb = new StringBuilder();
        for (String id : componentId) {
            String clientId;
            if (StringUtils.isBlank((String)id)) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            if ((clientId = HtmlRendererUtils.getComponentId(context, component, id)) == null) continue;
            sb.append(clientId);
        }
        return sb.toString();
    }

    public static String getComponentId(FacesContext context, UIComponent component, String componentId) {
        UIComponent partiallyComponent = ComponentUtils.findComponent((UIComponent)component, (String)componentId);
        if (partiallyComponent != null) {
            int rowIndex;
            String clientId = partiallyComponent.getClientId(context);
            if (partiallyComponent instanceof UISheet && (rowIndex = ((UISheet)partiallyComponent).getRowIndex()) >= 0 && clientId.endsWith(Integer.toString(rowIndex))) {
                return clientId.substring(0, clientId.lastIndexOf(58));
            }
            return clientId;
        }
        LOG.error("No Component found for id " + componentId + " search base component " + component.getClientId(context));
        return null;
    }

    @Deprecated
    public static String toStyleString(String key, Integer value) {
        StringBuilder buf = new StringBuilder();
        buf.append(key);
        buf.append(":");
        buf.append(value);
        buf.append("px; ");
        return buf.toString();
    }

    @Deprecated
    public static String toStyleString(String key, String value) {
        StringBuilder buf = new StringBuilder();
        buf.append(key);
        buf.append(":");
        buf.append(value);
        buf.append("; ");
        return buf.toString();
    }

    @Deprecated
    public static void renderTip(UIComponent component, TobagoResponseWriter writer) throws IOException {
        Object objTip = component.getAttributes().get("tip");
        if (objTip != null) {
            String tip = String.valueOf(objTip);
            writer.writeAttribute("title", tip, true);
        }
    }

    public static void renderImageTip(UIComponent component, TobagoResponseWriter writer) throws IOException {
        Object objTip = component.getAttributes().get("tip");
        if (objTip != null) {
            String tip = String.valueOf(objTip);
            writer.writeAttribute("alt", tip, true);
        } else {
            writer.writeAttribute("alt", "", false);
        }
    }

    public static String getJavascriptString(String str) {
        if (str != null) {
            return "\"" + str + "\"";
        }
        return null;
    }

    public static String getRenderedPartiallyJavascriptArray(FacesContext facesContext, UICommand command) {
        if (command == null) {
            return null;
        }
        return HtmlRendererUtils.getRenderedPartiallyJavascriptArray(facesContext, (UIComponent)command, (SupportsRenderedPartially)command);
    }

    public static String getRenderedPartiallyJavascriptArray(FacesContext facesContext, UIComponent searchBase, SupportsRenderedPartially supportsRenderedPartially) {
        String[] list = supportsRenderedPartially.getRenderedPartially();
        if (list == null || list.length == 0) {
            return null;
        }
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[");
        for (int i = 0; i < list.length; ++i) {
            if (i != 0) {
                strBuilder.append(",");
            }
            strBuilder.append("\"");
            strBuilder.append(HtmlRendererUtils.getComponentId(facesContext, searchBase, list[i]));
            strBuilder.append("\"");
        }
        strBuilder.append("]");
        return strBuilder.toString();
    }

    public static String getJavascriptArray(String[] list) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[");
        for (int i = 0; i < list.length; ++i) {
            if (i != 0) {
                strBuilder.append(",");
            }
            strBuilder.append("\"");
            strBuilder.append(list[i]);
            strBuilder.append("\"");
        }
        strBuilder.append("]");
        return strBuilder.toString();
    }

    public static void renderDojoDndSource(FacesContext context, UIComponent component) throws IOException {
        Object objDojoType = component.getAttributes().get("dojoType");
        if (null != objDojoType && (objDojoType.equals("dojo.dnd.Source") || objDojoType.equals("dojo.dnd.Target"))) {
            FacesContextUtils.addOnloadScript((FacesContext)context, (String)HtmlRendererUtils.createDojoDndType(component, component.getClientId(context), String.valueOf(objDojoType)));
        }
    }

    public static void renderDojoDndItem(UIComponent component, TobagoResponseWriter writer, boolean addStyle) throws IOException {
        Object objDndData;
        Object objDndType = component.getAttributes().get("dndType");
        if (objDndType != null) {
            writer.writeAttribute("dndType", String.valueOf(objDndType), false);
        }
        if ((objDndData = component.getAttributes().get("dndData")) != null) {
            writer.writeAttribute("dndData", String.valueOf(objDndData), false);
        }
        if (addStyle && (null != objDndType || null != objDndData)) {
            StyleClasses styles = StyleClasses.ensureStyleClasses((UIComponent)component);
            styles.addFullQualifiedClass("dojoDndItem");
        }
    }

    private static String createDojoDndType(UIComponent component, String clientId, String dojoType) {
        Object objCreator;
        Object objSingular;
        Object objAccept;
        Object objWithHandles;
        Object objSkipForm;
        Object objCopyOnly;
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("new ").append(dojoType).append("('").append(clientId).append("'");
        StringBuilder parameter = new StringBuilder();
        Object objHorizontal = component.getAttributes().get("horizontal");
        if (objHorizontal != null) {
            parameter.append("horizontal: ").append(String.valueOf(objHorizontal)).append(",");
        }
        if ((objCopyOnly = component.getAttributes().get("copyOnly")) != null) {
            parameter.append("copyOnly: ").append(String.valueOf(objCopyOnly)).append(",");
        }
        if ((objSkipForm = component.getAttributes().get("skipForm")) != null) {
            parameter.append("skipForm: ").append(String.valueOf(objSkipForm)).append(",");
        }
        if ((objWithHandles = component.getAttributes().get("withHandles")) != null) {
            parameter.append("withHandles: ").append(String.valueOf(objWithHandles)).append(",");
        }
        if ((objAccept = component.getAttributes().get("accept")) != null) {
            String accept = null;
            if (objAccept instanceof String[]) {
                String[] allowed = (String[])objAccept;
                if (allowed.length > 1) {
                    accept = "'" + allowed[0] + "'";
                    for (int i = 1; i < allowed.length; ++i) {
                        accept = accept + ",'" + allowed[i] + "'";
                    }
                }
            } else {
                accept = (String)objAccept;
            }
            parameter.append("accept: [").append(accept).append("],");
        }
        if ((objSingular = component.getAttributes().get("singular")) != null) {
            parameter.append("singular: ").append(String.valueOf(objSingular)).append(",");
        }
        if ((objCreator = component.getAttributes().get("creator")) != null) {
            parameter.append("creator: ").append(String.valueOf(objCreator)).append(",");
        }
        if (parameter.length() > 0) {
            parameter.deleteCharAt(parameter.lastIndexOf(","));
            strBuilder.append(",{").append((CharSequence)parameter).append("}");
        }
        strBuilder.append(");");
        return strBuilder.toString();
    }

    public static void checkForCommandFacet(UIComponent component, FacesContext facesContext, TobagoResponseWriter writer) throws IOException {
        HtmlRendererUtils.checkForCommandFacet(component, Arrays.asList(component.getClientId(facesContext)), facesContext, writer);
    }

    public static void checkForCommandFacet(UIComponent component, List<String> clientIds, FacesContext facesContext, TobagoResponseWriter writer) throws IOException {
        if (ComponentUtils.getBooleanAttribute((UIComponent)component, (String)"readonly") || ComponentUtils.getBooleanAttribute((UIComponent)component, (String)"disabled")) {
            return;
        }
        Map facets = component.getFacets();
        for (Map.Entry<String, UIComponent> entry : facets.entrySet()) {
            if (!(entry.getValue() instanceof UICommand)) continue;
            HtmlRendererUtils.addCommandFacet(clientIds, entry, facesContext, writer);
        }
    }

    private static void addCommandFacet(List<String> clientIds, Map.Entry<String, UIComponent> facetEntry, FacesContext facesContext, TobagoResponseWriter writer) throws IOException {
        for (String clientId : clientIds) {
            HtmlRendererUtils.writeScriptForClientId(clientId, facetEntry, facesContext, writer);
        }
    }

    private static void writeScriptForClientId(String clientId, Map.Entry<String, UIComponent> facetEntry, FacesContext facesContext, TobagoResponseWriter writer) throws IOException {
        if (facetEntry.getValue() instanceof UICommand && ((UICommand)facetEntry.getValue()).getRenderedPartially().length > 0) {
            writer.startJavascript();
            writer.write("var element = Tobago.element(\"");
            writer.write(clientId);
            writer.write("\");\n");
            writer.write("if (element) {\n");
            writer.write("   Tobago.addEventListener(element, \"");
            writer.write(facetEntry.getKey());
            writer.write("\", function(){Tobago.reloadComponent(this, '");
            writer.write(HtmlRendererUtils.getComponentIds(facesContext, facetEntry.getValue(), ((UICommand)facetEntry.getValue()).getRenderedPartially()));
            writer.write("','");
            writer.write(facetEntry.getValue().getClientId(facesContext));
            writer.write("', {})});\n");
            writer.write("}");
            writer.endJavascript();
        } else {
            UIComponent facetComponent = facetEntry.getValue();
            writer.startJavascript();
            writer.write("var element = Tobago.element(\"");
            writer.write(clientId + "\");\n");
            writer.write("if (element) {\n");
            writer.write("   Tobago.addEventListener(element, \"");
            writer.write(facetEntry.getKey());
            writer.write("\", function(){");
            String facetAction = (String)facetComponent.getAttributes().get("onclick");
            if (facetAction != null) {
                facetAction = StringUtils.replace((String)facetAction, (String)"@autoId", (String)facetComponent.getClientId(facesContext));
                writer.write(facetAction);
            } else {
                writer.write(HtmlRendererUtils.createSubmitAction(facetComponent.getClientId(facesContext), ComponentUtils.getBooleanAttribute((UIComponent)facetComponent, (String)"transition"), null, clientId));
            }
            writer.write("});\n}");
            writer.endJavascript();
        }
    }

    public static String createSubmitAction(String clientId, boolean transition, String target, String focus) {
        StringBuilder builder = new StringBuilder();
        builder.append("Tobago.submitAction(this,'");
        builder.append(clientId);
        builder.append("',{");
        if (!transition) {
            builder.append("transition:false");
            if (target != null || focus != null) {
                builder.append(',');
            }
        }
        if (target != null) {
            builder.append("target:'");
            builder.append(target);
            builder.append('\'');
            if (focus != null) {
                builder.append(',');
            }
        }
        if (focus != null) {
            builder.append("focus:'");
            builder.append(focus);
            builder.append('\'');
        }
        builder.append("});");
        return builder.toString();
    }

    @Deprecated
    public static void removeStyleClasses(UIComponent cell) {
        Object obj = cell.getAttributes().get("styleClass");
        if (obj != null && obj instanceof StyleClasses && cell.getRendererType() != null) {
            StyleClasses styleClasses = (StyleClasses)obj;
            if (!styleClasses.isEmpty()) {
                String rendererName = cell.getRendererType().substring(0, 1).toLowerCase(Locale.ENGLISH) + cell.getRendererType().substring(1);
                styleClasses.removeTobagoClasses(rendererName);
            }
            if (styleClasses.isEmpty()) {
                cell.getAttributes().remove("styleClass");
            }
        }
    }

    public static void encodeContextMenu(FacesContext facesContext, TobagoResponseWriter writer, UIComponent parent) throws IOException {
        AbstractUIMenu contextMenu = FacetUtils.getContextMenu((UIComponent)parent);
        if (contextMenu != null) {
            writer.startElement("ol", (UIComponent)contextMenu);
            writer.writeClassAttribute("tobago-menuBar tobago-menu-contextMenu");
            RenderUtils.encode(facesContext, (UIComponent)contextMenu);
            writer.endElement("ol");
        }
    }

    public static void addAcceleratorKey(FacesContext facesContext, UIComponent component, Character accessKey) {
        String clientId = component.getClientId(facesContext);
        String jsStatement = HtmlRendererUtils.createOnclickAcceleratorKeyJsStatement(clientId, accessKey.charValue(), null);
        FacesContextUtils.addMenuAcceleratorScript((FacesContext)facesContext, (String)jsStatement);
    }

    public static void writeDataAttributes(FacesContext context, TobagoResponseWriter writer, UIComponent component) throws IOException {
        Map dataAttributes = ComponentUtils.getDataAttributes((UIComponent)component);
        if (dataAttributes == null) {
            return;
        }
        ELContext elContext = context.getELContext();
        for (Map.Entry entry : dataAttributes.entrySet()) {
            Object mapKey = entry.getKey();
            String name = mapKey instanceof ValueExpression ? ((ValueExpression)mapKey).getValue(elContext).toString() : mapKey.toString();
            Object mapValue = entry.getValue();
            String value = mapValue instanceof ValueExpression ? ((ValueExpression)mapValue).getValue(elContext).toString() : mapValue.toString();
            writer.writeAttribute("data-" + name, value, true);
        }
    }
}

