/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.util;

import java.net.URLDecoder;
import java.util.Arrays;
import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.ValueHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionListener;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.component.UICommand;
import org.apache.myfaces.tobago.component.UIPopup;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.event.PopupFacetActionListener;
import org.apache.myfaces.tobago.internal.component.AbstractUICommandBase;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandRendererHelper {
    private static final Logger LOG = LoggerFactory.getLogger(CommandRendererHelper.class);
    private String onclick;
    private boolean disabled;
    private String href;
    private String target;

    public CommandRendererHelper(FacesContext facesContext, AbstractUICommandBase command) {
        this(facesContext, command, null);
    }

    public CommandRendererHelper(FacesContext facesContext, AbstractUICommandBase command, Tag tag) {
        this.disabled = ComponentUtils.getBooleanAttribute((UIComponent)command, (String)"disabled");
        if (this.disabled) {
            this.onclick = "";
            this.href = "";
        } else {
            String clientId;
            this.href = "#";
            UIPopup popup = (UIPopup)command.getFacet("popup");
            if (popup != null && !ComponentUtils.containsPopupActionListener((javax.faces.component.UICommand)command)) {
                command.addActionListener((ActionListener)new PopupFacetActionListener());
            }
            boolean defaultCommand = ComponentUtils.getBooleanAttribute((UIComponent)command, (String)"defaultCommand");
            boolean transition = ComponentUtils.getBooleanAttribute((UIComponent)command, (String)"transition");
            if (StringUtils.isNotEmpty((String)command.getLink()) || StringUtils.isNotEmpty((String)command.getResource())) {
                String url = this.generateUrl(facesContext, command);
                if (tag == Tag.ANCHOR) {
                    this.onclick = null;
                    this.href = url;
                    this.target = command.getTarget();
                } else {
                    this.onclick = "Tobago.navigateToUrl('" + url + "');";
                }
            } else if (StringUtils.isNotEmpty((String)command.getOnclick())) {
                this.onclick = this.prepareOnClick(facesContext, command);
            } else if (command.getRenderedPartially().length > 0) {
                clientId = command.getClientId(facesContext);
                Object[] componentIds = command.getRenderedPartially();
                boolean popupAction = ComponentUtils.containsPopupActionListener((javax.faces.component.UICommand)command);
                if (popupAction) {
                    if (componentIds.length != 1) {
                        LOG.warn("more than one partially rendered component is not supported for popup! using first one: " + Arrays.toString(componentIds));
                    }
                    this.onclick = "Tobago.Popup.openWithAction(this, '" + HtmlRendererUtils.getComponentId(facesContext, (UIComponent)command, (String)componentIds[0]) + "', '" + clientId + "');";
                } else {
                    this.onclick = "Tobago.reloadComponent(this, '" + HtmlRendererUtils.getComponentIds(facesContext, (UIComponent)command, (String[])componentIds) + "','" + clientId + "', {});";
                }
            } else if (defaultCommand) {
                clientId = command.getClientId(facesContext);
                ComponentUtils.findPage((FacesContext)facesContext, (UIComponent)command).setDefaultActionId(clientId);
                this.onclick = null;
            } else {
                clientId = command.getClientId(facesContext);
                String target = ComponentUtils.getStringAttribute((UIComponent)command, (String)"target");
                this.onclick = HtmlRendererUtils.createSubmitAction(clientId, transition, target, null);
            }
            if (command.getAttributes().get("popupClose") != null && ComponentUtils.isInPopup((UIComponent)command)) {
                String value = (String)command.getAttributes().get("popupClose");
                if (value.equals("immediate")) {
                    this.onclick = "Tobago.Popup.close(this);";
                } else if (value.equals("afterSubmit") && command instanceof UICommand && ((UICommand)command).getRenderedPartially().length > 0) {
                    this.onclick = "Tobago.Popup.unlockBehind();" + this.onclick + "Tobago.Popup.close(this);";
                }
            }
            this.onclick = this.appendConfirmationScript(this.onclick, (UIComponent)command);
        }
    }

    private String prepareOnClick(FacesContext facesContext, AbstractUICommandBase component) {
        String onclick = component.getOnclick();
        if (onclick.contains("@autoId")) {
            onclick = StringUtils.replace((String)onclick, (String)"@autoId", (String)component.getClientId(facesContext));
        }
        return onclick;
    }

    private String appendConfirmationScript(String onclick, UIComponent component) {
        ValueHolder confirmation = (ValueHolder)component.getFacet("confirmation");
        if (confirmation != null) {
            StringBuilder script = new StringBuilder("return confirm('");
            script.append(confirmation.getValue());
            script.append("')");
            if (onclick != null) {
                script.append(" && ");
                script.append(onclick);
            }
            onclick = script.toString();
        }
        return onclick;
    }

    private String generateUrl(FacesContext facesContext, AbstractUICommandBase component) {
        String url;
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        ExternalContext externalContext = facesContext.getExternalContext();
        if (component.getResource() != null) {
            boolean jsfResource = component.isJsfResource();
            url = ResourceManagerUtils.getPageWithoutContextPath((FacesContext)facesContext, (String)component.getResource());
            if (url != null) {
                if (jsfResource) {
                    url = viewHandler.getActionURL(facesContext, url);
                    url = externalContext.encodeActionURL(url);
                } else {
                    url = viewHandler.getResourceURL(facesContext, url);
                    url = externalContext.encodeResourceURL(url);
                }
            } else {
                url = "";
            }
        } else if (component.getLink() != null) {
            String link = component.getLink();
            url = link.startsWith("/") ? externalContext.encodeResourceURL(externalContext.getRequestContextPath() + link) : (org.apache.myfaces.tobago.internal.util.StringUtils.isUrl((String)link) ? link : externalContext.encodeResourceURL(link));
            StringBuilder builder = new StringBuilder(url);
            boolean firstParameter = !url.contains("?");
            for (UIComponent child : component.getChildren()) {
                if (!(child instanceof UIParameter)) continue;
                UIParameter parameter = (UIParameter)child;
                if (firstParameter) {
                    builder.append("?");
                    firstParameter = false;
                } else {
                    builder.append("&");
                }
                builder.append(parameter.getName());
                builder.append("=");
                Object value = parameter.getValue();
                builder.append(value != null ? URLDecoder.decode(value.toString()) : null);
            }
            url = builder.toString();
        } else {
            throw new AssertionError((Object)"Needed link or resource");
        }
        return url;
    }

    public String getOnclick() {
        return this.onclick;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public String getHref() {
        return this.href;
    }

    public String getTarget() {
        return this.target;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Tag {
        ANCHOR,
        BUTTON;

    }
}

