/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommandRendererBase
extends LayoutComponentRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(CommandRendererBase.class);

    public void decode(FacesContext facesContext, UIComponent component) {
        if (ComponentUtils.isOutputOnly((UIComponent)component)) {
            return;
        }
        String actionId = ComponentUtils.findPage((FacesContext)facesContext, (UIComponent)component).getActionId();
        String clientId = component.getClientId(facesContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("actionId = '" + actionId + "'");
            LOG.debug("clientId = '" + clientId + "'");
        }
        if (actionId != null && actionId.equals(clientId)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("queueEvent = '" + actionId + "'");
            }
            this.commandActivated(component);
        }
    }

    protected void commandActivated(UIComponent component) {
        component.queueEvent((FacesEvent)new ActionEvent(component));
    }

    public String getImageWithPath(FacesContext facesContext, String image, boolean disabled) {
        String imageWithPath = null;
        if (disabled) {
            imageWithPath = ResourceManagerUtils.getDisabledImageWithPath((FacesContext)facesContext, (String)image);
        }
        if (imageWithPath == null) {
            imageWithPath = ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)image);
        }
        return imageWithPath;
    }
}

