/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.facelets.extension;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.el.ELAdaptor;
import com.sun.facelets.tag.MetaRule;
import com.sun.facelets.tag.MetaRuleset;
import com.sun.facelets.tag.Metadata;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.jsf.ComponentConfig;
import com.sun.facelets.tag.jsf.ComponentHandler;
import com.sun.facelets.tag.jsf.ComponentSupport;
import java.io.IOException;
import java.util.List;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import org.apache.myfaces.tobago.component.InputSuggest;
import org.apache.myfaces.tobago.component.OnComponentCreated;
import org.apache.myfaces.tobago.component.OnComponentPopulated;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.component.UIGridLayout;
import org.apache.myfaces.tobago.component.UILabel;
import org.apache.myfaces.tobago.component.UIPanel;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.facelets.SuggestMethodRule;
import org.apache.myfaces.tobago.facelets.SupportsMarkupRule;
import org.apache.myfaces.tobago.facelets.TobagoComponentHandler;
import org.apache.myfaces.tobago.internal.layout.LayoutUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TobagoLabelExtensionHandler
extends ComponentHandler {
    private static final Logger LOG = LoggerFactory.getLogger((Class)TobagoLabelExtensionHandler.class);
    private static final String DEFAULT_COLUMNS = "auto;*";
    private TagAttribute labelWidthAttribute;
    private TagAttribute tipAttribute;
    private TagAttribute labelAttribute;
    private TagAttribute markupAttribute;
    private TagAttribute fieldIdAttribute;
    private Class subComponentLastType = Object.class;
    private Metadata subComponentMapper;

    public TobagoLabelExtensionHandler(ComponentConfig config) {
        super(config);
        this.labelWidthAttribute = this.getAttribute("labelWidth");
        this.tipAttribute = this.getAttribute("tip");
        this.labelAttribute = this.getAttribute("label");
        this.markupAttribute = this.getAttribute("markup");
        this.fieldIdAttribute = this.getAttribute("fieldId");
    }

    protected abstract String getSubComponentType();

    protected abstract String getSubRendererType();

    protected String getRows() {
        return "auto";
    }

    protected String getColumns(String first) {
        return first + ";*";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyNextHandler(FaceletContext ctx, UIComponent panel) throws IOException, FacesException, ELException {
        if (ComponentSupport.isNew((UIComponent)panel)) {
            UIComponent input = (UIComponent)panel.getChildren().remove(1);
            try {
                input.getAttributes().put("tobago.panel", panel);
                this.nextHandler.apply(ctx, input);
            }
            finally {
                input.getAttributes().remove("tobago.panel");
            }
            UIComponent date = null;
            if (panel.getChildCount() > 1) {
                date = (UIComponent)panel.getChildren().get(1);
            }
            panel.getChildren().add(input);
            if (date != null) {
                panel.getChildren().add(date);
            }
        } else {
            UIComponent input = (UIComponent)panel.getChildren().get(1);
            this.nextHandler.apply(ctx, input);
        }
    }

    protected void onComponentCreated(FaceletContext faceletContext, UIComponent panel, UIComponent parent) {
        Application application = faceletContext.getFacesContext().getApplication();
        UIViewRoot root = ComponentSupport.getViewRoot((FaceletContext)faceletContext, (UIComponent)parent);
        this.addGridLayout(faceletContext, panel, root);
        this.addLabel(faceletContext, (UIPanel)panel, root);
        String uid = this.fieldIdAttribute != null ? this.fieldIdAttribute.getValue(faceletContext) : root.createUniqueId();
        if (this.checkForAlreadyCreated(panel, uid)) {
            return;
        }
        UIComponent input = application.createComponent(this.getSubComponentType());
        input.setRendererType(this.getSubRendererType());
        input.setId(uid);
        this.setSubComponentAttributes(faceletContext, input);
        this.enrichInput(faceletContext, input);
        panel.getChildren().add(input);
    }

    protected void enrichInput(FaceletContext faceletContext, UIComponent input) {
    }

    private void addLabel(FaceletContext faceletContext, UIPanel panel, UIViewRoot root) {
        ValueExpression expression;
        String uid = root.createUniqueId();
        if (this.checkForAlreadyCreated((UIComponent)panel, uid)) {
            return;
        }
        Application application = faceletContext.getFacesContext().getApplication();
        UILabel label = (UILabel)application.createComponent("org.apache.myfaces.tobago.Label");
        label.setRendererType("Label");
        label.setId(uid);
        label.getAttributes().put("for", "@auto");
        if (this.tipAttribute != null) {
            if (this.tipAttribute.isLiteral()) {
                panel.setTip(this.tipAttribute.getValue(faceletContext));
            } else {
                expression = this.tipAttribute.getValueExpression(faceletContext, String.class);
                ELAdaptor.setExpression((UIComponent)panel, (String)"tip", (ValueExpression)expression);
            }
        }
        if (this.labelAttribute != null) {
            if (this.labelAttribute.isLiteral()) {
                label.setValue((Object)this.labelAttribute.getValue(faceletContext));
            } else {
                expression = this.labelAttribute.getValueExpression(faceletContext, String.class);
                ELAdaptor.setExpression((UIComponent)label, (String)"value", (ValueExpression)expression);
            }
        }
        if (this.markupAttribute != null) {
            if (this.markupAttribute.isLiteral()) {
                label.setMarkup(Markup.valueOf((String)this.markupAttribute.getValue()));
            } else {
                expression = this.markupAttribute.getValueExpression(faceletContext, Object.class);
                ELAdaptor.setExpression((UIComponent)label, (String)"markup", (ValueExpression)expression);
            }
        }
        panel.getChildren().add(label);
    }

    private boolean checkForAlreadyCreated(UIComponent panel, String uid) {
        if (panel.getChildCount() > 0) {
            List list = panel.getChildren();
            for (int i = 0; i < list.size(); ++i) {
                UIComponent child = (UIComponent)list.get(i);
                if (!uid.equals(child.getId())) continue;
                return true;
            }
        }
        return false;
    }

    protected void onComponentPopulated(FaceletContext faceletContext, UIComponent component, UIComponent parent) {
        super.onComponentPopulated(faceletContext, component, parent);
        if (component.getChildren().size() > 1 && component.getChildren().get(1) instanceof EditableValueHolder) {
            TobagoComponentHandler.addDefaultValidators(faceletContext.getFacesContext(), (EditableValueHolder)component.getChildren().get(1));
        }
    }

    private void addGridLayout(FaceletContext faceletContext, UIComponent panel, UIViewRoot root) {
        Application application = faceletContext.getFacesContext().getApplication();
        UIGridLayout gridLayout = (UIGridLayout)application.createComponent("org.apache.myfaces.tobago.GridLayout");
        gridLayout.setRendererType("GridLayout");
        if (this.labelWidthAttribute != null) {
            String columns = this.getColumns(this.labelWidthAttribute.getValue(faceletContext));
            if (!LayoutUtils.checkTokens((String)columns)) {
                LOG.warn("Illegal value for columns = \"" + columns + "\" replacing with default: \"" + DEFAULT_COLUMNS + "\"");
                columns = DEFAULT_COLUMNS;
            }
            gridLayout.setColumns(columns);
        } else {
            gridLayout.setColumns(this.getColumns("auto"));
        }
        gridLayout.setRows(this.getRows());
        gridLayout.setId(root.createUniqueId());
        if (gridLayout instanceof OnComponentCreated) {
            ((OnComponentCreated)gridLayout).onComponentCreated(faceletContext.getFacesContext(), panel);
        }
        panel.getFacets().put("layout", gridLayout);
        if (gridLayout instanceof OnComponentPopulated) {
            ((OnComponentPopulated)gridLayout).onComponentPopulated(faceletContext.getFacesContext(), panel);
        }
    }

    private void setSubComponentAttributes(FaceletContext ctx, Object instance) {
        if (instance != null) {
            Class<?> type = instance.getClass();
            if (this.subComponentMapper == null || !this.subComponentLastType.equals(type)) {
                this.subComponentLastType = type;
                this.subComponentMapper = this.createSubComponentMetaRuleset(type).finish();
            }
            this.subComponentMapper.applyMetadata(ctx, instance);
        }
    }

    protected MetaRuleset createSubComponentMetaRuleset(Class aClass) {
        MetaRuleset metaRuleset = super.createMetaRuleset(aClass);
        metaRuleset.ignore("tip");
        metaRuleset.ignore("labelWidth");
        if (SupportsMarkup.class.isAssignableFrom(aClass)) {
            metaRuleset.addRule((MetaRule)SupportsMarkupRule.INSTANCE);
        }
        if (InputSuggest.class.isAssignableFrom(aClass)) {
            metaRuleset.addRule((MetaRule)SuggestMethodRule.INSTANCE);
        }
        return metaRuleset;
    }

    protected MetaRuleset createMetaRuleset(Class aClass) {
        MetaRuleset metaRuleset = super.createMetaRuleset(aClass);
        TagAttribute[] attrs = this.tag.getAttributes().getAll();
        for (int i = 0; i < attrs.length; ++i) {
            TagAttribute attr = attrs[i];
            if (attr.getLocalName().equals("rendered")) continue;
            metaRuleset.ignore(attr.getLocalName());
        }
        return metaRuleset;
    }
}

