/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.webapp;

import java.io.IOException;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.myfaces.tobago.portlet.PortletUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class Secret
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String KEY = Secret.class.getName();
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final int SECRET_LENGTH = 16;
    private static final boolean COMMONS_CODEC_AVAILABLE = Secret.commonsCodecAvailable();
    private String secret;

    private static boolean commonsCodecAvailable() {
        try {
            Base64.encodeBase64URLSafeString((byte[])new byte[0]);
            return true;
        }
        catch (Error e) {
            return false;
        }
    }

    private Secret() {
        byte[] bytes = new byte[16];
        RANDOM.nextBytes(bytes);
        this.secret = COMMONS_CODEC_AVAILABLE ? this.encodeBase64(bytes) : this.encodeHex(bytes);
    }

    private String encodeBase64(byte[] bytes) {
        return Base64.encodeBase64URLSafeString((byte[])bytes);
    }

    private String encodeHex(byte[] bytes) {
        StringBuilder builder = new StringBuilder(32);
        for (byte b : bytes) {
            builder.append(String.format("%02x", b));
        }
        return builder.toString();
    }

    public static boolean check(FacesContext facesContext) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String fromRequest = (String)requestParameterMap.get(KEY);
        Object session = facesContext.getExternalContext().getSession(true);
        Secret secret = session instanceof HttpSession ? (Secret)((HttpSession)session).getAttribute(KEY) : (Secret)PortletUtils.getAttributeFromSessionForApplication((Object)session, (String)KEY);
        return secret != null && secret.secret.equals(fromRequest);
    }

    public static void encode(FacesContext facesContext, TobagoResponseWriter writer) throws IOException {
        writer.startElement("input", null);
        writer.writeAttribute("type", "hidden", false);
        writer.writeAttribute("name", KEY, false);
        writer.writeAttribute("id", KEY, false);
        Object session = facesContext.getExternalContext().getSession(true);
        Secret secret = session instanceof HttpSession ? (Secret)((HttpSession)session).getAttribute(KEY) : (Secret)PortletUtils.getAttributeFromSessionForApplication((Object)session, (String)KEY);
        writer.writeAttribute("value", secret.secret, false);
        writer.endElement("input");
    }

    public static void create(HttpSession session) {
        session.setAttribute(KEY, (Object)new Secret());
    }
}

