/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.validator;

import java.util.Arrays;
import java.util.Locale;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.apache.commons.fileupload.FileItem;
import org.apache.myfaces.tobago.internal.component.AbstractUIFileInput;
import org.apache.myfaces.tobago.internal.util.ContentType;
import org.apache.myfaces.tobago.util.MessageUtils;

public class FileItemValidator
implements Validator,
StateHolder {
    public static final String VALIDATOR_ID = "org.apache.myfaces.tobago.FileItem";
    public static final String SIZE_LIMIT_MESSAGE_ID = "org.apache.myfaces.tobago.FileItemValidator.SIZE_LIMIT";
    public static final String CONTENT_TYPE_MESSAGE_ID = "org.apache.myfaces.tobago.FileItemValidator.CONTENT_TYPE";
    private Integer maxSize = null;
    private String[] contentType;
    private boolean transientValue;

    public void validate(FacesContext facesContext, UIComponent component, Object value) throws ValidatorException {
        if (value != null && component instanceof AbstractUIFileInput) {
            FileItem file = (FileItem)value;
            if (this.maxSize != null && file.getSize() > (long)this.maxSize.intValue()) {
                FacesMessage facesMessage = MessageUtils.getMessage((FacesContext)facesContext, (Locale)facesContext.getViewRoot().getLocale(), (FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)SIZE_LIMIT_MESSAGE_ID, (Object[])new Object[]{this.maxSize, component.getId()});
                throw new ValidatorException(facesMessage);
            }
            if (file.getSize() > 0L && this.contentType != null && this.contentType.length > 0) {
                boolean found = false;
                for (String contentTypeStr : this.contentType) {
                    if (!ContentType.valueOf(contentTypeStr).match(ContentType.valueOf(file.getContentType()))) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    String message = this.contentType.length == 1 ? this.contentType[0] : Arrays.toString(this.contentType);
                    FacesMessage facesMessage = MessageUtils.getMessage((FacesContext)facesContext, (Locale)facesContext.getViewRoot().getLocale(), (FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)CONTENT_TYPE_MESSAGE_ID, (Object[])new Object[]{message, component.getId()});
                    throw new ValidatorException(facesMessage);
                }
            }
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        if (maxSize > 0) {
            this.maxSize = maxSize;
        }
    }

    public String[] getContentType() {
        return this.contentType;
    }

    public void setContentType(String[] contentType) {
        this.contentType = contentType;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.maxSize, this.contentType};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.maxSize = (Integer)values[0];
        this.contentType = (String[])values[1];
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean newTransientValue) {
        this.transientValue = newTransientValue;
    }
}

