/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.util;

import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.application.ProjectStage;
import org.apache.myfaces.tobago.config.TobagoConfig;

public class DebugUtils {
    private DebugUtils() {
    }

    public static String toString(UIComponent component, int offset) {
        return DebugUtils.toString(component, offset, false);
    }

    public static String toString(UIComponent component, int offset, boolean asFacet) {
        StringBuilder result = new StringBuilder();
        if (component == null) {
            result.append("null");
        } else {
            Map facets;
            result.append('\n');
            if (!asFacet) {
                result.append(DebugUtils.spaces(offset));
                result.append(DebugUtils.toString(component));
            }
            if ((facets = component.getFacets()).size() > 0) {
                for (Map.Entry entry : facets.entrySet()) {
                    UIComponent facet = (UIComponent)entry.getValue();
                    result.append('\n');
                    result.append(DebugUtils.spaces(offset + 1));
                    result.append('\"');
                    result.append((String)entry.getKey());
                    result.append("\" = ");
                    result.append(DebugUtils.toString(facet));
                    result.append(DebugUtils.toString(facet, offset + 1, true));
                }
            }
            for (Map.Entry o : component.getChildren()) {
                result.append(DebugUtils.toString((UIComponent)o, offset + 1, false));
            }
        }
        return result.toString();
    }

    public static String toString(UIComponent component) {
        StringBuilder buf = new StringBuilder(component.getClass().getName());
        buf.append('@');
        buf.append(Integer.toHexString(component.hashCode()));
        buf.append(" ");
        buf.append(component.getRendererType());
        buf.append(" ");
        if (component instanceof UIViewRoot) {
            buf.append(((UIViewRoot)component).getViewId());
        } else {
            buf.append(component.getId());
            buf.append(" ");
            buf.append(component.getClientId(FacesContext.getCurrentInstance()));
        }
        return buf.toString();
    }

    public static String spaces(int n) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            buffer.append("  ");
        }
        return buffer.toString();
    }

    public static void addDevelopmentMessage(FacesContext facesContext, String message) {
        if (TobagoConfig.getInstance(FacesContext.getCurrentInstance()).getProjectStage() == ProjectStage.Development) {
            facesContext.addMessage(null, new FacesMessage(message));
        }
    }
}

