/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit;

import java.util.Locale;
import javax.faces.component.UIComponent;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LabelWithAccessKey {
    private static final Logger LOG = LoggerFactory.getLogger(LabelWithAccessKey.class);
    private String text;
    private Character accessKey;
    private int pos = -1;
    public static final char INDICATOR = '_';
    public static final String ESCAPED_INDICATOR = "__";

    public LabelWithAccessKey(String label) {
        this.text = label;
        this.setup(this.text);
    }

    public LabelWithAccessKey(UIComponent component) {
        Object value = "Label".equals(component.getRendererType()) ? component.getAttributes().get("value") : component.getAttributes().get("label");
        this.text = value == null ? null : String.valueOf(value);
        this.setup(this.text);
    }

    private void findIndicator(String label, int index, int escapedIndicatorCount) {
        if ((index = label.indexOf(95, index)) == -1) {
            this.text = label;
        } else if (index == label.length() - 1) {
            LOG.warn("_ in label is last char, this is not allowedlabel='" + label + "'.");
            this.text = label.substring(0, label.length() - 1);
            this.pos = -1;
        } else if (label.charAt(index + 1) == '_') {
            this.findIndicator(label, index + 2, ++escapedIndicatorCount);
        } else {
            this.text = label.substring(0, index) + label.substring(index + 1);
            this.accessKey = Character.valueOf(this.text.charAt(index));
            this.pos = index - escapedIndicatorCount;
        }
    }

    public void setup(String label) {
        if (label != null) {
            this.findIndicator(label, 0, 0);
            this.text = StringUtils.replace((String)this.text, (String)ESCAPED_INDICATOR, (String)String.valueOf('_'));
        } else if (this.accessKey != null && this.text != null) {
            this.pos = this.text.toLowerCase(Locale.ENGLISH).indexOf(Character.toLowerCase(this.accessKey.charValue()));
        }
    }

    public void reset() {
        this.text = null;
        this.accessKey = null;
        this.pos = -1;
    }

    public String getText() {
        return this.text;
    }

    public Character getAccessKey() {
        return this.accessKey;
    }

    public int getPos() {
        return this.pos;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setAccessKey(Character accessKey) {
        this.accessKey = accessKey;
    }
}

