/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit;

import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputRendererBase
extends LayoutComponentRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(InputRendererBase.class);

    public void decode(FacesContext context, UIComponent component) {
        if (!(component instanceof UIInput)) {
            return;
        }
        UIInput uiInput = (UIInput)component;
        if (ComponentUtils.isOutputOnly(component)) {
            return;
        }
        String clientId = component.getClientId(context);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.containsKey(clientId)) {
            String newValue = (String)requestParameterMap.get(clientId);
            if (LOG.isDebugEnabled()) {
                boolean password = ComponentUtils.getBooleanAttribute(component, "password");
                LOG.debug("clientId = '" + clientId + "'");
                LOG.debug("requestParameterMap.get(clientId) = '" + (password ? StringUtils.leftPad((String)"", (int)newValue.length(), (char)'*') : newValue) + "'");
            }
            uiInput.setSubmittedValue((Object)newValue);
        }
    }
}

