/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.myfaces.tobago.internal.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreePath
implements Serializable {
    private int[] path;

    public TreePath(int ... path) {
        assert (path[0] == 0);
        this.path = path;
    }

    public TreePath(List<Integer> pathList) {
        assert (pathList.get(0) == 0);
        this.path = new int[pathList.size()];
        for (int i = 0; i < this.path.length; ++i) {
            this.path[i] = pathList.get(i);
        }
    }

    public TreePath(TreePath position, int addendum) {
        this.path = new int[position.path.length + 1];
        System.arraycopy(position.path, 0, this.path, 0, position.path.length);
        this.path[position.path.length] = addendum;
    }

    public TreePath(String string) throws NumberFormatException {
        this(StringUtils.parseIntegerList(string, "_"));
    }

    public int[] getPath() {
        return this.path;
    }

    public int getLength() {
        return this.path.length;
    }

    public String getPathString() {
        StringBuilder builder = new StringBuilder();
        for (int item : this.path) {
            builder.append("_");
            builder.append(item);
        }
        return builder.toString();
    }

    @Deprecated
    public String getParentPathString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.path.length - 1; ++i) {
            builder.append("_");
            builder.append(this.path[i]);
        }
        return builder.toString();
    }

    public DefaultMutableTreeNode getNode(DefaultMutableTreeNode tree) {
        if (tree == null) {
            return null;
        }
        for (int i = 1; i < this.path.length; ++i) {
            int pos = this.path[i];
            if (pos >= tree.getChildCount()) {
                return null;
            }
            tree = (DefaultMutableTreeNode)tree.getChildAt(pos);
        }
        return tree;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreePath nodeIndex = (TreePath)o;
        return Arrays.equals(this.path, nodeIndex.path);
    }

    public int hashCode() {
        return this.path != null ? Arrays.hashCode(this.path) : 0;
    }

    public String toString() {
        return this.getPathString();
    }
}

