/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.layout;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.layout.PixelMeasure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Measure
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(Measure.class);
    public static final Measure ZERO = Measure.valueOf(0);
    public static final Measure MAX = Measure.valueOf(Integer.MAX_VALUE);

    public static Measure valueOf(Measure value) {
        if (value == null) {
            return ZERO;
        }
        return value;
    }

    public static Measure valueOf(int value) {
        return PixelMeasure.pixelValueOf(value);
    }

    public static Measure valueOf(Integer value) {
        if (value == null) {
            return ZERO;
        }
        return Measure.valueOf((int)value);
    }

    public static Measure valueOf(Number value) {
        if (value == null) {
            return ZERO;
        }
        return Measure.valueOf(value.intValue());
    }

    public static Measure valueOf(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return ZERO;
        }
        try {
            if (value.endsWith("px")) {
                return Measure.valueOf(Integer.parseInt(value.substring(0, value.length() - 2)));
            }
            return Measure.valueOf(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Can't parse to any measure: '" + value + "'", e);
        }
    }

    public static Measure valueOf(Object object) {
        if (object instanceof Measure) {
            return Measure.valueOf((Measure)object);
        }
        if (object instanceof Number) {
            return Measure.valueOf((Number)object);
        }
        if (object instanceof String) {
            return Measure.valueOf((String)object);
        }
        if (object == null) {
            return ZERO;
        }
        return Measure.valueOf(object.toString());
    }

    @Deprecated
    public static Measure parse(String value) {
        return Measure.valueOf(value);
    }

    public abstract Measure add(Measure var1);

    public abstract Measure add(int var1);

    public abstract Measure multiply(int var1);

    public abstract Measure divide(int var1);

    @Deprecated
    public Measure substractNotNegative(Measure m) {
        return this.subtractNotNegative(m);
    }

    public abstract Measure subtractNotNegative(Measure var1);

    public abstract Measure subtract(Measure var1);

    public abstract Measure subtract(int var1);

    public boolean greaterThan(Measure measure) {
        return measure != null && this.getPixel() > measure.getPixel();
    }

    public boolean greaterOrEqualThan(Measure measure) {
        return measure != null && this.getPixel() >= measure.getPixel();
    }

    public boolean lessThan(Measure measure) {
        return measure != null && this.getPixel() < measure.getPixel();
    }

    public boolean lessOrEqualThan(Measure measure) {
        return measure != null && this.getPixel() <= measure.getPixel();
    }

    public abstract int getPixel();

    public static Measure max(List<Measure> list) {
        Measure max = ZERO;
        for (Measure measure : list) {
            if (!max.lessThan(measure)) continue;
            max = measure;
        }
        return max;
    }

    public static Measure min(List<Measure> list) {
        Measure min = MAX;
        for (Measure measure : list) {
            if (!min.greaterThan(measure)) continue;
            min = measure;
        }
        return min;
    }

    public static Measure max(Measure m1, Measure m2) {
        if (m1 != null) {
            return m1.lessThan(m2) ? m2 : m1;
        }
        return m2 != null ? m2 : ZERO;
    }

    public static Measure min(Measure m1, Measure m2) {
        if (m1 != null) {
            return m1.greaterThan(m2) ? m2 : m1;
        }
        return m2 != null ? m2 : MAX;
    }
}

