/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.webapp;

import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.faces.component.UIComponent;
import org.apache.myfaces.tobago.internal.util.Deprecation;
import org.apache.myfaces.tobago.renderkit.html.StyleClasses;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TobagoResponseWriterBase
extends TobagoResponseWriter {
    private static final Logger LOG = LoggerFactory.getLogger(TobagoResponseWriterBase.class);
    protected static final Set<String> EMPTY_TAG = new HashSet<String>(Arrays.asList("br", "area", "link", "img", "param", "hr", "input", "col", "base", "meta"));
    @Deprecated
    public static final String XML_VERSION_1_0_ENCODING_UTF_8 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    @Deprecated
    public static final int XML_VERSION_1_0_ENCODING_UTF_8_LENGTH = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".length();
    protected static final char[] XML_VERSION_1_0_ENCODING_UTF_8_CHARS = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".toCharArray();
    private UIComponent component;
    private boolean startStillOpen;
    private final Writer writer;
    private final String contentType;
    private final String characterEncoding;

    protected TobagoResponseWriterBase(Writer writer, String contentType, String characterEncoding) {
        this.writer = writer;
        this.contentType = contentType;
        this.characterEncoding = characterEncoding != null ? characterEncoding : "UTF-8";
    }

    protected final Writer getWriter() {
        return this.writer;
    }

    protected final UIComponent getComponent() {
        return this.component;
    }

    protected final void setComponent(UIComponent component) {
        this.component = component;
    }

    protected final boolean isStartStillOpen() {
        return this.startStillOpen;
    }

    protected final void setStartStillOpen(boolean startStillOpen) {
        this.startStillOpen = startStillOpen;
    }

    protected final String findValue(Object value, String property) {
        if (value != null) {
            return value instanceof String ? (String)value : value.toString();
        }
        if (property != null) {
            if (this.component != null) {
                Object object = this.component.getAttributes().get(property);
                if (object != null) {
                    return object instanceof String ? (String)object : object.toString();
                }
                return null;
            }
            String trace = this.getCallingClassStackTraceElementString();
            LOG.error("Don't know what to do! Property defined, but no component to get a value. " + trace.substring(trace.indexOf(40)));
            LOG.error("value = 'null'");
            LOG.error("property = '" + property + "'");
            return null;
        }
        String trace = this.getCallingClassStackTraceElementString();
        LOG.error("Don't know what to do! No value and no property defined. " + trace.substring(trace.indexOf(40)));
        LOG.error("value = 'null'");
        LOG.error("property = 'null'");
        return null;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    public void write(String string) throws IOException {
        this.writeInternal(this.writer, string);
    }

    protected final void writeInternal(Writer writer, String string) throws IOException {
        this.closeOpenTag();
        writer.write(string);
    }

    public void write(int i) throws IOException {
        this.closeOpenTag();
        this.writer.write(i);
    }

    public void write(char[] chars) throws IOException {
        this.closeOpenTag();
        this.writer.write(chars);
    }

    public void write(String string, int i, int i1) throws IOException {
        this.closeOpenTag();
        this.writer.write(string, i, i1);
    }

    public void close() throws IOException {
        this.closeOpenTag();
        this.writer.close();
    }

    public void flush() throws IOException {
        this.closeOpenTag();
    }

    protected void closeOpenTag() throws IOException {
        if (this.startStillOpen) {
            this.writer.write("\n>");
            this.startStillOpen = false;
        }
    }

    public void startDocument() throws IOException {
    }

    public void endDocument() throws IOException {
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void startElement(String name, UIComponent currentComponent) throws IOException {
        this.startElementInternal(this.writer, name, currentComponent);
    }

    protected void startElementInternal(Writer writer, String name, UIComponent currentComponent) throws IOException {
        this.component = currentComponent;
        if (this.startStillOpen) {
            writer.write("\n>");
        }
        writer.write("<");
        writer.write(name);
        this.startStillOpen = true;
    }

    public void endElement(String name) throws IOException {
        this.endElementInternal(this.writer, name);
    }

    public void writeComment(Object obj) throws IOException {
        this.closeOpenTag();
        String comment = obj.toString();
        this.write("<!--");
        this.write(comment);
        this.write("-->");
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        String attribute = this.findValue(value, property);
        this.writeAttribute(name, attribute, true);
    }

    protected final String getCallingClassStackTraceElementString() {
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        int i = 1;
        while (stackTrace[i].getClassName().contains("TobagoResponseWriter")) {
            ++i;
        }
        return stackTrace[i].toString();
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        if (value != null) {
            URI uri = URI.create(value.toString());
            this.writeAttribute(name, (Object)uri.toASCIIString(), property);
        }
    }

    public void writeAttribute(String name, String value, boolean escape) throws IOException {
        this.writeAttributeInternal(this.writer, name, value, escape);
    }

    @Deprecated
    public String getStyleClasses() {
        if (this.component == null) {
            return null;
        }
        StyleClasses clazz = (StyleClasses)this.component.getAttributes().get("styleClass");
        if (clazz != null) {
            return clazz.toString();
        }
        return null;
    }

    @Deprecated
    public void writeClassAttribute() throws IOException {
        Deprecation.LOG.warn("Please use writeClassAttribute(org.apache.myfaces.tobago.renderkit.css.Classes)");
        StyleClasses clazz = (StyleClasses)this.component.getAttributes().get("styleClass");
        if (clazz != null) {
            this.writeAttribute("class", clazz.toString(), false);
        }
    }

    protected void endElementInternal(Writer writer, String name) throws IOException {
        if (EMPTY_TAG.contains(name)) {
            this.closeEmptyTag();
        } else {
            if (this.startStillOpen) {
                writer.write("\n>");
            }
            writer.write("</");
            writer.write(name);
            writer.write(">");
        }
        this.startStillOpen = false;
    }

    protected abstract void closeEmptyTag() throws IOException;

    protected void writeAttributeInternal(Writer writer, String name, String value, boolean escape) throws IOException {
        if (!this.startStillOpen) {
            String trace = this.getCallingClassStackTraceElementString();
            String error = "Cannot write attribute when start-tag not open. name = '" + name + "' " + "value = '" + value + "' " + trace.substring(trace.indexOf(40));
            LOG.error(error);
            throw new IllegalStateException(error);
        }
        if (value != null) {
            writer.write(32);
            writer.write(name);
            writer.write("=\"");
            this.writerAttributeValue(value, escape);
            writer.write(34);
        }
    }

    protected abstract void writerAttributeValue(String var1, boolean var2) throws IOException;
}

