/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JndiUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JndiUtils.class);

    public static Object getJndiProperty(Context ctx, String ... path) throws NamingException {
        return JndiUtils.getJndiProperty(ctx, null, path);
    }

    public static Object getJndiProperty(Context ctx, Object defaultValue, String ... path) throws NamingException {
        Binding b;
        String name = "java:comp/env";
        for (int i = 0; i < path.length && (b = JndiUtils.getBinding(ctx, name, path[i])) != null; ++i) {
            if (i == path.length - 1) {
                Object obj = b.getObject();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Value: " + obj);
                }
                return obj;
            }
            name = name + "/" + path[i];
        }
        return defaultValue;
    }

    private static Binding getBinding(Context ctx, String name, String path) throws NamingException {
        NamingEnumeration<Binding> ne = ctx.listBindings(name);
        while (ne.hasMore()) {
            Binding b = ne.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Property: " + b.getName());
            }
            if (!path.equals(b.getName())) continue;
            return b;
        }
        return null;
    }
}

