/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import org.apache.commons.lang.StringUtils;

public class ContentType {
    private String primaryType;
    private String subType;

    public ContentType(String contentType) {
        this.parse(contentType);
    }

    private void parse(String contentType) {
        String[] values = StringUtils.split((String)contentType, (String)"/");
        if (values.length != 2) {
            throw new IllegalArgumentException("ContentType '" + contentType + "' not recognized.");
        }
        this.primaryType = values[0];
        this.subType = values[1];
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public String getSubType() {
        return this.subType;
    }

    public boolean match(ContentType contentType) {
        return this.primaryType.equalsIgnoreCase(contentType.getPrimaryType()) && ("*".equals(this.subType) || this.subType.equalsIgnoreCase(contentType.getSubType()));
    }

    public String toString() {
        return this.primaryType + "/" + this.subType;
    }

    public static ContentType valueOf(String s) {
        return new ContentType(s);
    }
}

